/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.social.authentication.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.internal.AbstractDocumentConfigurationSource;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceValueProvider;
import org.xwiki.model.reference.SpaceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="socialAuthDocument")
public class SocialAuthDocumentConfigurationSource
extends AbstractDocumentConfigurationSource {
    @Inject
    private Execution execution;
    @Inject
    private EntityReferenceValueProvider valueProvider;
    private static final String GLOBAL_CONFIGURATION_KEY = "xwiki.authentication.socialLogin.globalConfiguration";
    private static final String IGNORE_PREFIX = "socialauth.";
    private static final String XWIKI_SPACE = "XWiki";
    private static final String SOCIAL_LOGIN_CONFIGURATION_CLASS = "SocialLoginConfigurationClass";
    private static final String SOCIAL_LOGIN_CONFIGURATION_DOCUMENT = "SocialLoginConfiguration";

    protected DocumentReference getClassReference() {
        if (this.isGlobalConfiguration()) {
            return new DocumentReference(this.getMainWikiName(), XWIKI_SPACE, SOCIAL_LOGIN_CONFIGURATION_CLASS);
        }
        return new DocumentReference(SOCIAL_LOGIN_CONFIGURATION_CLASS, new SpaceReference(XWIKI_SPACE, this.getCurrentWikiReference()));
    }

    protected DocumentReference getDocumentReference() {
        if (this.isGlobalConfiguration()) {
            return new DocumentReference(this.getMainWikiName(), XWIKI_SPACE, SOCIAL_LOGIN_CONFIGURATION_DOCUMENT);
        }
        return new DocumentReference(SOCIAL_LOGIN_CONFIGURATION_DOCUMENT, new SpaceReference(XWIKI_SPACE, this.getCurrentWikiReference()));
    }

    public <T> T getProperty(String key) {
        return this.getPropertyInternal(StringUtils.substringAfter((String)key, (String)IGNORE_PREFIX));
    }

    public boolean containsKey(String key) {
        return this.containsKeyInternal(StringUtils.substringAfter((String)key, (String)IGNORE_PREFIX));
    }

    private boolean isGlobalConfiguration() {
        String globalConfig = this.getContext().getWiki().Param(GLOBAL_CONFIGURATION_KEY);
        return "1".equals(globalConfig);
    }

    private XWikiContext getContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private String getMainWikiName() {
        String wikiName = this.valueProvider.getDefaultValue(EntityType.WIKI);
        return wikiName;
    }

    public <T> T getPropertyInternal(String key) {
        return (T)this.getPropertyObject(key);
    }

    public boolean containsKeyInternal(String key) {
        return this.getPropertyObject(key) != null;
    }

    private Object getPropertyObject(String key) {
        DocumentReference documentReference = this.getFailsafeDocumentReference();
        DocumentReference classReference = this.getFailsafeClassReference();
        Object result = documentReference != null && classReference != null ? this.getDocumentAccessBridge().getProperty(documentReference, classReference, key) : null;
        return result;
    }

    public boolean isEmpty() {
        return this.getKeys().isEmpty();
    }

    private DocumentReference getFailsafeDocumentReference() {
        DocumentReference documentReference;
        try {
            documentReference = this.getDocumentReference();
        }
        catch (Exception e) {
            documentReference = null;
        }
        return documentReference;
    }

    private DocumentReference getFailsafeClassReference() {
        DocumentReference classReference;
        try {
            classReference = this.getClassReference();
        }
        catch (Exception e) {
            classReference = null;
        }
        return classReference;
    }
}

