/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.users.internal;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelConfiguration;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.users.AbstractUserManager;
import org.xwiki.users.User;
import org.xwiki.users.UserManager;
import org.xwiki.users.internal.InvalidUser;

@Component
@Singleton
public class MetaUserManager
extends AbstractUserManager {
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configuration;
    @Inject
    private ModelConfiguration modelConfiguration;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="explicit")
    private EntityReferenceResolver<String> nameResolver;

    @Override
    public User getUser(String identifier, boolean force) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return new InvalidUser(null, this.serializer);
        }
        User result = null;
        try {
            Map managers = this.componentManager.getInstanceMap(UserManager.class);
            managers.remove("default");
            for (UserManager manager : managers.values()) {
                result = manager.getUser(identifier);
                if (result == null) continue;
                return result;
            }
        }
        catch (ComponentLookupException managers) {
            // empty catch block
        }
        if (force) {
            try {
                UserManager defaultManager = (UserManager)this.componentManager.getInstance(UserManager.class, (String)this.configuration.getProperty("users.defaultUserManager", (Object)"wiki"));
                return defaultManager.getUser(identifier, true);
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
        }
        return new InvalidUser(this.getDefaultReference(identifier), this.serializer);
    }

    @Override
    public User getCurrentUser() {
        DocumentReference currentUser = this.bridge.getCurrentUserReference();
        if (currentUser == null) {
            return null;
        }
        return this.getUser(currentUser.toString());
    }

    private DocumentReference getDefaultReference(String identifier) {
        WikiReference defaultWiki = new WikiReference((String)this.configuration.getProperty("users.defaultWiki", (Object)this.modelConfiguration.getDefaultReferenceValue(EntityType.WIKI)));
        return new DocumentReference(this.nameResolver.resolve((Object)identifier, EntityType.DOCUMENT, new Object[]{new EntityReference("XWiki", EntityType.SPACE, (EntityReference)defaultWiki)}));
    }
}

