/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.velocity.tools.JSONTool;

public class JSONTool {
    private Logger logger = LoggerFactory.getLogger(JSONTool.class);

    public String serialize(Object object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setAnnotationIntrospector((AnnotationIntrospector)CustomAnnotationIntrospector.INTROSPECTOR);
            SimpleModule m = new SimpleModule("org.json", new Version(1, 0, 0, "", "org.json", "json"));
            m.addSerializer(JSONObject.class, (JsonSerializer)new JSONObjectSerializer(this));
            m.addSerializer(JSONArray.class, (JsonSerializer)new JSONArraySerializer(this));
            mapper.registerModule((Module)m);
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to serialize object to JSON", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public JSON parse(String json) {
        try {
            return JSONSerializer.toJSON((Object)json);
        }
        catch (net.sf.json.JSONException ex) {
            this.logger.info("Tried to parse invalid JSON: [{}], exception was: {}", (Object)StringUtils.abbreviate((String)json, (int)32), (Object)ex.getMessage());
            return null;
        }
    }

    public JSONObject parseToJSONObject(String json) {
        try {
            return new JSONObject(json);
        }
        catch (JSONException ex) {
            this.logger.info("Tried to parse invalid JSON: [{}], exception was: {}", (Object)StringUtils.abbreviate((String)json, (int)32), (Object)ex.getMessage());
            return null;
        }
    }

    public JSONArray parseToJSONArray(String json) {
        try {
            return new JSONArray(json);
        }
        catch (JSONException ex) {
            this.logger.info("Tried to parse invalid JSON: [{}], exception was: {}", (Object)StringUtils.abbreviate((String)json, (int)32), (Object)ex.getMessage());
            return null;
        }
    }
}

