/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.environment.Environment;
import org.xwiki.environment.internal.ServletEnvironment;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;
import org.xwiki.url.internal.standard.StandardURLConfiguration;

@Component
@Named(value="contextpath+actionservletpath")
@Singleton
public class ContextAndActionURLNormalizer
implements URLNormalizer<ExtendedURL>,
Initializable {
    private static final String URL_SEGMENT_DELIMITER = "/";
    private static final String IGNORED_MAPPING_CHARACTERS = "/*";
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource configurationSource;
    @Inject
    private Container container;
    @Inject
    private Environment environment;
    @Inject
    private StandardURLConfiguration urlConfiguration;
    private String defaultServletMapping;
    private Collection<String> validServletMappings = new HashSet();
    private String virtualWikiServletMapping;

    public void initialize() {
        this.virtualWikiServletMapping = this.urlConfiguration.getWikiPathPrefix();
        this.defaultServletMapping = this.urlConfiguration.getEntityPathPrefix();
        this.validServletMappings.add(this.defaultServletMapping);
        if (this.environment instanceof ServletEnvironment) {
            for (String mapping : ((ServletEnvironment)this.environment).getServletContext().getServletRegistration("action").getMappings()) {
                this.validServletMappings.add(StringUtils.strip((String)mapping, (String)IGNORED_MAPPING_CHARACTERS));
            }
        }
    }

    public ExtendedURL normalize(ExtendedURL partialURL) {
        ArrayList<String> segments = new ArrayList<String>();
        String contextPath = this.getContextPath();
        if (contextPath == null) {
            throw new RuntimeException(String.format("Failed to normalize the URL [%s] since the application's Servlet context couldn't be computed.", partialURL));
        }
        if (StringUtils.isNotEmpty((CharSequence)(contextPath = StringUtils.strip((String)contextPath, (String)URL_SEGMENT_DELIMITER)))) {
            segments.add(contextPath);
        }
        List servletPath = this.getActionServletMapping();
        for (String segment : servletPath) {
            if (!StringUtils.isNotEmpty((CharSequence)segment)) continue;
            segments.add(segment);
        }
        segments.addAll(partialURL.getSegments());
        return new ExtendedURL(segments, partialURL.getParameters());
    }

    private String getContextPath() {
        String contextPath = this.getContextPathFromConfiguration();
        if (contextPath == null) {
            contextPath = this.getContextPathFromCurrentRequest();
        }
        if (contextPath == null) {
            contextPath = this.getContextPathFromApplicationContext();
        }
        return contextPath;
    }

    private String getContextPathFromConfiguration() {
        return (String)this.configurationSource.getProperty("xwiki.webapppath");
    }

    private String getContextPathFromCurrentRequest() {
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest) {
            return ((ServletRequest)request).getHttpServletRequest().getContextPath();
        }
        return null;
    }

    private String getContextPathFromApplicationContext() {
        if (this.environment instanceof ServletEnvironment) {
            return ((ServletEnvironment)this.environment).getServletContext().getContextPath();
        }
        return null;
    }

    private List<String> getActionServletMapping() {
        String result = this.defaultServletMapping;
        if (this.container.getRequest() instanceof ServletRequest) {
            HttpServletRequest hsRequest = ((ServletRequest)this.container.getRequest()).getHttpServletRequest();
            result = hsRequest.getServletPath();
            if (this.virtualWikiServletMapping.equals(result = StringUtils.strip((String)result, (String)IGNORED_MAPPING_CHARACTERS))) {
                return Arrays.asList(this.virtualWikiServletMapping, StringUtils.substringBetween((String)hsRequest.getPathInfo(), (String)URL_SEGMENT_DELIMITER));
            }
            if (!this.validServletMappings.contains(result)) {
                result = this.defaultServletMapping;
            }
        }
        return Collections.singletonList(result);
    }
}

