/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DeletedAttachment;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.XWikiDefaultURLFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class XWikiServletURLFactory
extends XWikiDefaultURLFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiServletURLFactory.class);
    protected URL serverURL;
    protected String contextPath;

    public XWikiServletURLFactory() {
    }

    public XWikiServletURLFactory(URL serverURL, String contextPath, String actionPath) {
        this.serverURL = serverURL;
        this.contextPath = contextPath;
    }

    public XWikiServletURLFactory(XWikiContext context) {
        this.init(context);
    }

    public void init(XWikiContext context) {
        this.contextPath = context.getWiki().getWebAppPath(context);
        try {
            this.serverURL = new URL(this.getProtocol(context) + "://" + this.getHost(context));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    private String getProtocol(XWikiContext context) {
        String protocol = context.getURL().getProtocol();
        if (context.getRequest() != null && "http".equalsIgnoreCase(protocol = context.getRequest().getScheme()) && context.getRequest().isSecure()) {
            protocol = "https";
        }
        return context.getWiki().Param("xwiki.url.protocol", protocol);
    }

    private String getHost(XWikiContext context) {
        URL url = context.getURL();
        String proxyHost = StringUtils.substringBefore((String)context.getRequest().getHeader("x-forwarded-host"), (String)",");
        if (!StringUtils.isEmpty((CharSequence)proxyHost)) {
            return proxyHost;
        }
        URL homeParam = XWikiServletURLFactory.getXWikiHomeParameter((XWikiContext)context);
        if (homeParam != null && context.isMainWiki()) {
            url = homeParam;
        }
        return url.getHost() + (url.getPort() < 0 ? "" : ":" + url.getPort());
    }

    private static URL getXWikiHomeParameter(XWikiContext context) {
        String surl = XWikiServletURLFactory.getXWikiHomeParameterAsString((XWikiContext)context);
        if (!StringUtils.isEmpty((CharSequence)surl)) {
            try {
                return XWikiServletURLFactory.normalizeURL((String)surl, (XWikiContext)context);
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Could not create URL from xwiki.cfg xwiki.home parameter: " + surl + " Ignoring parameter.");
            }
        }
        return null;
    }

    private static String getXWikiHomeParameterAsString(XWikiContext context) {
        return context.getWiki().Param("xwiki.home", null);
    }

    public URL getServerURL(XWikiContext context) throws MalformedURLException {
        return this.getServerURL(context.getWikiId(), context);
    }

    public URL getServerURL(String xwikidb, XWikiContext context) throws MalformedURLException {
        URL homeParam;
        if (xwikidb == null || xwikidb.equals(context.getOriginalWikiId())) {
            return this.serverURL;
        }
        if (context.isMainWiki(xwikidb) && (homeParam = XWikiServletURLFactory.getXWikiHomeParameter((XWikiContext)context)) != null) {
            return homeParam;
        }
        URL url = context.getWiki().getServerURL(xwikidb, context);
        return url == null ? this.serverURL : url;
    }

    public URL createURL(String web, String name, String action, boolean redirect, XWikiContext context) {
        return this.createURL(web, name, action, context);
    }

    public URL createURL(String web, String name, String action, String querystring, String anchor, String xwikidb, XWikiContext context) {
        URL result;
        if ("view".equals(action) && context.getLinksAction() != null) {
            action = context.getLinksAction();
        }
        if (context.getLinksQueryString() != null) {
            querystring = querystring == null ? context.getLinksQueryString() : querystring + "&" + context.getLinksQueryString();
        }
        StringBuffer newpath = new StringBuffer(this.contextPath);
        this.addServletPath(newpath, xwikidb, context);
        this.addAction(newpath, action, context);
        this.addSpace(newpath, web, action, context);
        this.addName(newpath, name, action, context);
        if (!StringUtils.isEmpty((CharSequence)querystring)) {
            newpath.append("?");
            newpath.append(StringUtils.removeEnd((String)StringUtils.removeEnd((String)querystring, (String)"&"), (String)"&amp;"));
        }
        if (!StringUtils.isEmpty((CharSequence)anchor)) {
            newpath.append("#");
            newpath.append(this.encodeWithinQuery(anchor, context));
        }
        try {
            result = XWikiServletURLFactory.normalizeURL((URL)new URL(this.getServerURL(xwikidb, context), newpath.toString()), (XWikiContext)context);
        }
        catch (MalformedURLException e) {
            result = null;
        }
        return result;
    }

    private void addServletPath(StringBuffer newpath, String xwikidb, XWikiContext context) {
        if (xwikidb == null) {
            xwikidb = context.getWikiId();
        }
        String spath = context.getWiki().getServletPath(xwikidb, context);
        newpath.append(spath);
    }

    private void addAction(StringBuffer newpath, String action, XWikiContext context) {
        boolean showViewAction = context.getWiki().showViewAction(context);
        if (!"view".equals(action) || showViewAction) {
            newpath.append(action);
            newpath.append("/");
        }
    }

    private void addSpace(StringBuffer newpath, String space, String action, XWikiContext context) {
        boolean skipDefaultSpace = context.getWiki().skipDefaultSpaceInURLs(context);
        if (skipDefaultSpace) {
            String defaultSpace = context.getWiki().getDefaultSpace(context);
            boolean bl = skipDefaultSpace = space.equals(defaultSpace) && "view".equals(action);
        }
        if (!skipDefaultSpace) {
            newpath.append(this.encodeWithinPath(space, context));
            newpath.append("/");
        }
    }

    private void addName(StringBuffer newpath, String name, String action, XWikiContext context) {
        XWiki xwiki = context.getWiki();
        if (xwiki.useDefaultAction(context) || !name.equals(xwiki.getDefaultPage(context)) || !"view".equals(action)) {
            newpath.append(this.encodeWithinPath(name, context));
        }
    }

    protected void addFileName(StringBuffer newpath, String filename, XWikiContext context) {
        this.addFileName(newpath, filename, true, context);
    }

    protected void addFileName(StringBuffer newpath, String filename, boolean encode, XWikiContext context) {
        newpath.append("/");
        if (encode) {
            newpath.append(this.encodeWithinPath(filename, context).replace("+", "%20"));
        } else {
            newpath.append(filename);
        }
    }

    private String encodeWithinPath(String name, XWikiContext context) {
        String encodedName;
        try {
            encodedName = URLEncoder.encode(name, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Missing charset [UTF-8]", e);
        }
        encodedName = encodedName.replaceAll("\\+", "%20");
        return encodedName;
    }

    private String encodeWithinQuery(String name, XWikiContext context) {
        return this.encodeWithinPath(name, context);
    }

    public URL createExternalURL(String web, String name, String action, String querystring, String anchor, String xwikidb, XWikiContext context) {
        return this.createURL(web, name, action, querystring, anchor, xwikidb, context);
    }

    public URL createSkinURL(String filename, String skin, XWikiContext context) {
        StringBuffer newpath = new StringBuffer(this.contextPath);
        newpath.append("skins/");
        newpath.append(skin);
        this.addFileName(newpath, filename, false, context);
        try {
            return XWikiServletURLFactory.normalizeURL((URL)new URL(this.getServerURL(context), newpath.toString()), (XWikiContext)context);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL createSkinURL(String filename, String web, String name, String xwikidb, XWikiContext context) {
        StringBuffer newpath = new StringBuffer(this.contextPath);
        this.addServletPath(newpath, xwikidb, context);
        this.addAction(newpath, "skin", context);
        this.addSpace(newpath, web, "skin", context);
        this.addName(newpath, name, "skin", context);
        this.addFileName(newpath, filename, false, context);
        try {
            return XWikiServletURLFactory.normalizeURL((URL)new URL(this.getServerURL(xwikidb, context), newpath.toString()), (XWikiContext)context);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL createResourceURL(String filename, boolean forceSkinAction, XWikiContext context) {
        StringBuffer newpath = new StringBuffer(this.contextPath);
        if (forceSkinAction) {
            this.addServletPath(newpath, context.getWikiId(), context);
            this.addAction(newpath, "skin", context);
        }
        newpath.append("resources");
        this.addFileName(newpath, filename, false, context);
        try {
            return XWikiServletURLFactory.normalizeURL((URL)new URL(this.getServerURL(context), newpath.toString()), (XWikiContext)context);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL createTemplateURL(String filename, XWikiContext context) {
        StringBuffer newpath = new StringBuffer(this.contextPath);
        newpath.append("templates");
        this.addFileName(newpath, filename, false, context);
        try {
            return XWikiServletURLFactory.normalizeURL((URL)new URL(this.getServerURL(context), newpath.toString()), (XWikiContext)context);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL createAttachmentURL(String filename, String web, String name, String action, String querystring, String xwikidb, XWikiContext context) {
        block7: {
            if (context != null && "viewrev".equals(context.getAction()) && context.get((Object)"rev") != null && this.isContextDoc(xwikidb, web, name, context)) {
                try {
                    String docRevision = context.get((Object)"rev").toString();
                    XWikiAttachment attachment = this.findAttachmentForDocRevision(context.getDoc(), docRevision, filename, context);
                    if (attachment != null) {
                        long arbId = this.findDeletedAttachmentForDocRevision(context.getDoc(), docRevision, filename, context);
                        return this.createAttachmentRevisionURL(filename, web, name, attachment.getVersion(), arbId, querystring, xwikidb, context);
                    }
                    action = "viewattachrev";
                }
                catch (XWikiException e) {
                    if (!LOGGER.isErrorEnabled()) break block7;
                    LOGGER.error("Exception while trying to get attachment version !", (Throwable)e);
                }
            }
        }
        StringBuffer newpath = new StringBuffer(this.contextPath);
        this.addServletPath(newpath, xwikidb, context);
        this.addAction(newpath, action, context);
        this.addSpace(newpath, web, action, context);
        this.addName(newpath, name, action, context);
        this.addFileName(newpath, filename, context);
        if (!StringUtils.isEmpty((CharSequence)querystring)) {
            newpath.append("?");
            newpath.append(StringUtils.removeEnd((String)StringUtils.removeEnd((String)querystring, (String)"&"), (String)"&amp;"));
        }
        try {
            return XWikiServletURLFactory.normalizeURL((URL)new URL(this.getServerURL(xwikidb, context), newpath.toString()), (XWikiContext)context);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean isContextDoc(String wiki, String space, String name, XWikiContext context) {
        if (context == null || context.getDoc() == null) {
            return false;
        }
        XWikiDocument doc = context.getDoc();
        return doc.getDocumentReference().getLastSpaceReference().getName().equals(space) && doc.getDocumentReference().getName().equals(name) && (wiki == null || doc.getDocumentReference().getWikiReference().getName().equals(wiki));
    }

    public URL createAttachmentRevisionURL(String filename, String web, String name, String revision, String querystring, String xwikidb, XWikiContext context) {
        return this.createAttachmentRevisionURL(filename, web, name, revision, -1L, querystring, xwikidb, context);
    }

    public URL createAttachmentRevisionURL(String filename, String web, String name, String revision, long recycleId, String querystring, String xwikidb, XWikiContext context) {
        String action = "downloadrev";
        StringBuffer newpath = new StringBuffer(this.contextPath);
        this.addServletPath(newpath, xwikidb, context);
        this.addAction(newpath, action, context);
        this.addSpace(newpath, web, action, context);
        this.addName(newpath, name, action, context);
        this.addFileName(newpath, filename, context);
        String qstring = "rev=" + revision;
        if (recycleId >= 0L) {
            qstring = qstring + "&rid=" + recycleId;
        }
        if (!StringUtils.isEmpty((CharSequence)querystring)) {
            qstring = qstring + "&" + querystring;
        }
        newpath.append("?");
        newpath.append(StringUtils.removeEnd((String)StringUtils.removeEnd((String)qstring, (String)"&"), (String)"&amp;"));
        try {
            return XWikiServletURLFactory.normalizeURL((URL)new URL(this.getServerURL(xwikidb, context), newpath.toString()), (XWikiContext)context);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getURL(URL url, XWikiContext context) {
        String relativeURL = "";
        try {
            if (url != null) {
                String surl = url.toString();
                if (!surl.startsWith(this.serverURL.toString())) {
                    relativeURL = surl;
                } else {
                    String anchor;
                    StringBuffer sbuf = new StringBuffer(url.getPath());
                    String querystring = url.getQuery();
                    if (!StringUtils.isEmpty((CharSequence)querystring)) {
                        sbuf.append("?");
                        sbuf.append(StringUtils.removeEnd((String)StringUtils.removeEnd((String)querystring, (String)"&"), (String)"&amp;"));
                    }
                    if (!StringUtils.isEmpty((CharSequence)(anchor = url.getRef()))) {
                        sbuf.append("#");
                        sbuf.append(anchor);
                    }
                    relativeURL = sbuf.toString();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create URL", (Throwable)e);
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)relativeURL, (CharSequence)"/");
    }

    public URL getRequestURL(XWikiContext context) {
        URL url = super.getRequestURL(context);
        try {
            URL servurl = this.getServerURL(context);
            return XWikiServletURLFactory.normalizeURL((URL)new URL(servurl.getProtocol(), servurl.getHost(), servurl.getPort(), url.getFile()), (XWikiContext)context);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Failed to create request URL", (Throwable)e);
            return url;
        }
    }

    public XWikiAttachment findAttachmentForDocRevision(XWikiDocument doc, String docRevision, String filename, XWikiContext context) throws XWikiException {
        XWikiAttachment attachment = null;
        XWikiDocument rdoc = context.getWiki().getDocument(doc, docRevision, context);
        if (filename != null) {
            attachment = rdoc.getAttachment(filename);
        }
        return attachment;
    }

    public long findDeletedAttachmentForDocRevision(XWikiDocument doc, String docRevision, String filename, XWikiContext context) throws XWikiException {
        XWikiAttachment attachment = null;
        XWikiDocument rdoc = context.getWiki().getDocument(doc, docRevision, context);
        if (context.getWiki().hasAttachmentRecycleBin(context) && filename != null && (attachment = rdoc.getAttachment(filename)) != null) {
            List deleted = context.getWiki().getAttachmentRecycleBinStore().getAllDeletedAttachments(attachment, context, true);
            Collections.reverse(deleted);
            for (DeletedAttachment entry : deleted) {
                if (!entry.getDate().after(rdoc.getDate())) continue;
                return entry.getId();
            }
        }
        return -1L;
    }

    protected static URL normalizeURL(URL url, XWikiContext context) throws MalformedURLException {
        return XWikiServletURLFactory.normalizeURL((String)url.toExternalForm(), (XWikiContext)context);
    }

    protected static URL normalizeURL(String url, XWikiContext context) throws MalformedURLException {
        String encodedURLAsString = context.getResponse().encodeURL(url);
        encodedURLAsString = encodedURLAsString.replaceAll(";jsessionid=.*?(?=\\?|$)", "");
        return new URL(encodedURLAsString);
    }
}

