/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWikiServletResponse
implements XWikiResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiServletResponse.class);
    private HttpServletResponse response;
    private int httpStatus;

    public XWikiServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public int getStatus() {
        return this.httpStatus;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    public void sendRedirect(String redirect) throws IOException {
        if (StringUtils.isBlank((CharSequence)redirect)) {
            return;
        }
        if (StringUtils.containsAny((CharSequence)redirect, (char[])new char[]{'\r', '\n'})) {
            LOGGER.warn("Possible HTTP Response Splitting attack, attempting to redirect to [{}]", (Object)redirect);
            return;
        }
        if (redirect.matches("[a-z0-9]+://.*") && !redirect.matches("[a-z0-9]+://" + Utils.getContext().getRequest().getServerName() + "[:/].*")) {
            LOGGER.warn("Possible phishing attack, attempting to redirect to [{}]", (Object)redirect);
            return;
        }
        this.httpStatus = 302;
        this.response.sendRedirect(redirect);
    }

    public void setContentType(String type) {
        this.response.setContentType(type);
    }

    public void setBufferSize(int i) {
        this.response.setBufferSize(i);
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public void resetBuffer() {
        this.response.resetBuffer();
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void reset() {
        this.response.reset();
    }

    public void setContentLength(int length) {
        this.response.setContentLength(length);
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    public void setCharacterEncoding(String s) {
        this.response.setCharacterEncoding(s);
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public void addCookie(String cookieName, String cookieValue, int age) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setVersion(1);
        cookie.setMaxAge(age);
        this.response.addCookie(cookie);
    }

    public void removeCookie(String cookieName, XWikiRequest request) {
        Cookie cookie = request.getCookie(cookieName);
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setPath(cookie.getPath());
            this.addCookie(cookie);
        }
    }

    public void setLocale(Locale locale) {
        this.response.setLocale(locale);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void setDateHeader(String name, long value) {
        this.response.setDateHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void addDateHeader(String name, long value) {
        this.response.addDateHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.response.addIntHeader(name, value);
    }

    public void setStatus(int i) {
        this.response.setStatus(i);
        this.httpStatus = i;
    }

    @Deprecated
    public void setStatus(int i, String s) {
        this.response.setStatus(i, s);
        this.httpStatus = i;
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public String encodeURL(String s) {
        return this.response.encodeURL(s);
    }

    public String encodeRedirectURL(String s) {
        return this.response.encodeRedirectURL(s);
    }

    @Deprecated
    public String encodeUrl(String s) {
        return this.response.encodeUrl(s);
    }

    @Deprecated
    public String encodeRedirectUrl(String s) {
        return this.response.encodeRedirectUrl(s);
    }

    public void sendError(int i, String s) throws IOException {
        this.httpStatus = i;
        this.response.sendError(i, s);
    }

    public void sendError(int i) throws IOException {
        this.httpStatus = i;
        this.response.sendError(i);
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public String getHeader(String s) {
        return this.response.getHeader(s);
    }

    public Collection<String> getHeaders(String s) {
        return this.response.getHeaders(s);
    }

    public Collection<String> getHeaderNames() {
        return this.response.getHeaderNames();
    }
}

