/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.skinx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.skinx.AbstractDocumentSkinExtensionPlugin;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class JsSkinExtensionPlugin
extends AbstractDocumentSkinExtensionPlugin {
    public static final String JSX_CLASS_NAME = "XWiki.JavaScriptExtension";
    public static final EntityReference JSX_CLASS_REFERENCE = new EntityReference("JavaScriptExtension", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    public static final String PLUGIN_NAME = "jsx";
    public static final String DEFER_DEFAULT_PARAM = "xwiki.plugins.skinx.deferred.default";

    public JsSkinExtensionPlugin(String name, String className, XWikiContext context) {
        super(PLUGIN_NAME, className, context);
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
    }

    public String getLink(String documentName, XWikiContext context) {
        StringBuilder result = new StringBuilder(128);
        result.append("<script type='text/javascript' src='");
        result.append(context.getWiki().getURL(documentName, PLUGIN_NAME, "language=" + this.sanitize(context.getLanguage()) + "&amp;hash=" + this.getHash(documentName, context) + this.parametersAsQueryString(documentName, context), context));
        String defaultDeferString = context.getWiki().Param(DEFER_DEFAULT_PARAM);
        Boolean defaultDefer = !StringUtils.isEmpty((CharSequence)defaultDeferString) ? Boolean.valueOf(defaultDeferString) : true;
        if (BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)this.getParameter("defer", documentName, context)), (boolean)defaultDefer)) {
            result.append("' defer='defer");
        }
        result.append("'></script>\n");
        return result.toString();
    }

    protected String getExtensionClassName() {
        return JSX_CLASS_NAME;
    }

    protected String getExtensionName() {
        return "Javascript";
    }

    public String endParsing(String content, XWikiContext context) {
        return super.endParsing(content, context);
    }

    private int getHash(String documentName, XWikiContext context) {
        StringBuilder result = new StringBuilder();
        try {
            XWikiDocument doc = context.getWiki().getDocument(documentName, context);
            List jsxs = doc.getXObjects(JSX_CLASS_REFERENCE);
            if (jsxs == null || jsxs.isEmpty()) {
                return 0;
            }
            for (BaseObject jsx : jsxs) {
                if (jsx == null) continue;
                result.append(jsx.getLargeStringValue("code"));
            }
        }
        catch (XWikiException xWikiException) {
            // empty catch block
        }
        return result.toString().hashCode();
    }
}

