/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.skinx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.skinx.AbstractDocumentSkinExtensionPlugin;
import java.util.List;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class CssSkinExtensionPlugin
extends AbstractDocumentSkinExtensionPlugin {
    public static final String SSX_CLASS_NAME = "XWiki.StyleSheetExtension";
    public static final EntityReference SSX_CLASS_REFERENCE = new EntityReference("StyleSheetExtension", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    public static final String PLUGIN_NAME = "ssx";

    public CssSkinExtensionPlugin(String name, String className, XWikiContext context) {
        super(PLUGIN_NAME, className, context);
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
    }

    public String getLink(String documentName, XWikiContext context) {
        return "<link rel='stylesheet' type='text/css' href='" + context.getWiki().getURL(documentName, PLUGIN_NAME, "language=" + this.sanitize(context.getLanguage()) + "&amp;hash=" + this.getHash(documentName, context) + this.parametersAsQueryString(documentName, context), context) + "'/>";
    }

    protected String getExtensionClassName() {
        return SSX_CLASS_NAME;
    }

    protected String getExtensionName() {
        return "Stylesheet";
    }

    public String endParsing(String content, XWikiContext context) {
        return super.endParsing(content, context);
    }

    public BaseClass getExtensionClass(XWikiContext context) {
        super.getExtensionClass(context);
        try {
            XWikiDocument doc = context.getWiki().getDocument(this.getExtensionClassName(), context);
            boolean needsUpdate = false;
            BaseClass bclass = doc.getXClass();
            if (context.get((Object)"initdone") != null) {
                return bclass;
            }
            if (needsUpdate |= bclass.addStaticListField("contentType", "Content Type", "CSS|LESS")) {
                context.getWiki().saveDocument(doc, context);
            }
            return bclass;
        }
        catch (Exception ex) {
            LOGGER.error("Cannot initialize skin extension class [{}]", (Object)this.getExtensionClassName(), (Object)ex);
            return null;
        }
    }

    private int getHash(String documentName, XWikiContext context) {
        StringBuilder result = new StringBuilder();
        try {
            XWikiDocument doc = context.getWiki().getDocument(documentName, context);
            List ssxs = doc.getXObjects(SSX_CLASS_REFERENCE);
            if (ssxs == null || ssxs.isEmpty()) {
                return 0;
            }
            for (BaseObject ssx : ssxs) {
                if (ssx == null) continue;
                result.append(ssx.getLargeStringValue("code"));
            }
        }
        catch (XWikiException xWikiException) {
            // empty catch block
        }
        return result.toString().hashCode();
    }
}

