/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.push.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.json.JSONArray;
import org.json.JSONObject;
import org.phenotips.data.Patient;
import org.phenotips.data.PatientRepository;
import org.phenotips.data.push.PatientPushHistory;
import org.phenotips.data.push.PushPatientData;
import org.phenotips.data.push.PushPatientService;
import org.phenotips.data.push.PushServerConfigurationResponse;
import org.phenotips.data.push.PushServerGetPatientIDResponse;
import org.phenotips.data.push.PushServerInfo;
import org.phenotips.data.push.PushServerSendPatientResponse;
import org.phenotips.data.push.internal.DefaultPatientPushHistory;
import org.phenotips.data.push.internal.DefaultPushServerConfigurationResponse;
import org.phenotips.data.push.internal.DefaultPushServerGetPatientIDResponse;
import org.phenotips.data.push.internal.DefaultPushServerInfo;
import org.phenotips.data.push.internal.DefaultPushServerResponse;
import org.phenotips.data.push.internal.DefaultPushServerSendPatientResponse;
import org.phenotips.data.securestorage.PatientPushedToInfo;
import org.phenotips.data.securestorage.RemoteLoginData;
import org.phenotips.data.securestorage.SecureStorageManager;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class DefaultPushPatientService
implements PushPatientService {
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private PushPatientData internalService;
    @Inject
    private SecureStorageManager storageManager;
    @Inject
    private PatientRepository patientRepository;
    @Inject
    private AuthorizationManager access;
    @Inject
    private DocumentAccessBridge bridge;

    protected RemoteLoginData getStoredData(String remoteServerIdentifier) {
        String localUserName = this.getLocalUserName();
        return this.storageManager.getRemoteLoginData(localUserName, remoteServerIdentifier);
    }

    protected void storeUserData(String remoteServerIdentifier, String remoteUser, String loginToken) {
        String localUserName = this.getLocalUserName();
        this.storageManager.storeRemoteLoginData(localUserName, remoteServerIdentifier, remoteUser, loginToken);
    }

    protected void removeUserData(String remoteServerIdentifier) {
        String localUserName = this.getLocalUserName();
        this.storageManager.removeRemoteLoginData(localUserName, remoteServerIdentifier);
    }

    private String getLocalUserName() {
        XWikiContext context = this.getXContext();
        if (context.getUserReference() == null) {
            return null;
        }
        return context.getUserReference().getName();
    }

    private XWikiContext getXContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    @Override
    public Set<PushServerInfo> getAvailablePushTargets() {
        try {
            XWikiContext context = this.getXContext();
            XWiki xwiki = context.getWiki();
            XWikiDocument prefsDoc = xwiki.getDocument(new DocumentReference(context.getWikiId(), "XWiki", "XWikiPreferences"), context);
            List servers = prefsDoc.getXObjects(new DocumentReference(context.getWikiId(), "PhenoTips", "PushPatientServer"));
            TreeSet<PushServerInfo> response = new TreeSet<PushServerInfo>();
            if (servers == null || servers.isEmpty()) {
                return response;
            }
            for (BaseObject serverConfiguration : servers) {
                if (serverConfiguration == null) continue;
                this.logger.debug("   ...available: [{}]", (Object)serverConfiguration.getStringValue("name"));
                DefaultPushServerInfo info = new DefaultPushServerInfo(serverConfiguration.getStringValue("name"), serverConfiguration.getStringValue("url"), serverConfiguration.getStringValue("description"));
                response.add(info);
            }
            return response;
        }
        catch (Exception ex) {
            this.logger.error("Failed to get server list: {}", (Object)ex.getMessage(), (Object)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public Map<PushServerInfo, PatientPushHistory> getPushTargetsWithHistory(String localPatientID) {
        Set<PushServerInfo> servers = this.getAvailablePushTargets();
        TreeMap<PushServerInfo, PatientPushHistory> response = new TreeMap<PushServerInfo, PatientPushHistory>();
        for (PushServerInfo server : servers) {
            PatientPushHistory history = this.getPatientPushHistory(localPatientID, server.getServerID());
            response.put(server, history);
        }
        return response;
    }

    @Override
    public PatientPushHistory getPatientPushHistory(String localPatientID, String remoteServerIdentifier) {
        PatientPushedToInfo pushInfo = this.storageManager.getPatientPushInfo(localPatientID, remoteServerIdentifier);
        DefaultPatientPushHistory history = pushInfo == null ? null : new DefaultPatientPushHistory(pushInfo);
        return history;
    }

    private Patient getPatientByID(String patientID, String accessLevelName) {
        Patient patient = (Patient)this.patientRepository.get(patientID);
        if (patient == null) {
            return null;
        }
        if (accessLevelName.equals("push")) {
            accessLevelName = "view";
        }
        if (!this.access.hasAccess(Right.toRight((String)accessLevelName), this.bridge.getCurrentUserReference(), (EntityReference)patient.getDocument())) {
            this.logger.warn("Can't access patient [{}] at level [{}]: access level violation", (Object)patientID, (Object)accessLevelName);
            return null;
        }
        return patient;
    }

    private Set<String> parseJSONArrayIntoSet(String listOfStrings) {
        TreeSet<String> fieldSet = null;
        try {
            JSONArray fields;
            if (listOfStrings != null && (fields = new JSONArray(listOfStrings)) != null) {
                fieldSet = new TreeSet<String>();
                for (Object field : fields) {
                    fieldSet.add(field.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fieldSet;
    }

    @Override
    public JSONObject getLocalPatientJSON(String patientID, String exportFieldListJSON) {
        Patient patient = this.getPatientByID(patientID, "view");
        if (patient == null) {
            return null;
        }
        return patient.toJSON(this.parseJSONArrayIntoSet(exportFieldListJSON));
    }

    @Override
    public PushServerConfigurationResponse getRemoteConfiguration(String remoteServerIdentifier, String remoteUserName, String password, boolean saveUserToken) {
        PushServerConfigurationResponse response = this.internalService.getRemoteConfiguration(remoteServerIdentifier, remoteUserName, password, null);
        if (response != null && response.isSuccessful()) {
            if (saveUserToken) {
                this.storeUserData(remoteServerIdentifier, remoteUserName, response.getRemoteUserToken());
            } else {
                this.removeUserData(remoteServerIdentifier);
            }
        }
        return response;
    }

    @Override
    public void removeStoredLoginTokens(String remoteServerIdentifier) {
        this.removeUserData(remoteServerIdentifier);
    }

    @Override
    public PushServerConfigurationResponse getRemoteConfiguration(String remoteServerIdentifier) {
        RemoteLoginData storedData = this.getStoredData(remoteServerIdentifier);
        if (storedData == null || storedData.getRemoteUserName() == null || storedData.getLoginToken() == null) {
            return new DefaultPushServerConfigurationResponse(DefaultPushServerResponse.generateIncorrectCredentialsJSON());
        }
        PushServerConfigurationResponse response = this.internalService.getRemoteConfiguration(remoteServerIdentifier, storedData.getRemoteUserName(), null, storedData.getLoginToken());
        if (response != null && response.getRemoteUserToken() != null && response.getRemoteUserToken() != storedData.getLoginToken()) {
            this.storeUserData(remoteServerIdentifier, storedData.getRemoteUserName(), response.getRemoteUserToken());
        }
        return response;
    }

    @Override
    public PushServerSendPatientResponse sendPatient(String patientID, String exportFieldListJSON, String patientState, String groupName, String remoteGUID, String remoteServerIdentifier) {
        JSONObject patientStateJSON;
        Patient patient = this.getPatientByID(patientID, "push");
        if (patient == null) {
            return new DefaultPushServerSendPatientResponse(DefaultPushServerResponse.generateActionFailedJSON());
        }
        RemoteLoginData storedData = this.getStoredData(remoteServerIdentifier);
        if (storedData == null || storedData.getRemoteUserName() == null || storedData.getLoginToken() == null) {
            return new DefaultPushServerSendPatientResponse(DefaultPushServerResponse.generateIncorrectCredentialsJSON());
        }
        Set<String> exportFields = this.parseJSONArrayIntoSet(exportFieldListJSON);
        PushServerSendPatientResponse response = this.internalService.sendPatient(patient, exportFields, patientStateJSON = this.parsePatientStateToJSON(patientState), groupName, remoteGUID, remoteServerIdentifier, storedData.getRemoteUserName(), null, storedData.getLoginToken());
        if (response != null && response.isSuccessful()) {
            this.storageManager.storePatientPushInfo(patient.getDocument().getName(), remoteServerIdentifier, response.getRemotePatientGUID(), response.getRemotePatientID(), response.getRemotePatientURL());
        }
        return response;
    }

    @Override
    public PushServerSendPatientResponse sendPatient(String patientID, String exportFieldListJSON, String patientState, String groupName, String remoteGUID, String remoteServerIdentifier, String remoteUserName, String password) {
        JSONObject patientStateJSON;
        Patient patient = this.getPatientByID(patientID, "push");
        if (patient == null) {
            return new DefaultPushServerSendPatientResponse(DefaultPushServerResponse.generateActionFailedJSON());
        }
        Set<String> exportFields = this.parseJSONArrayIntoSet(exportFieldListJSON);
        PushServerSendPatientResponse response = this.internalService.sendPatient(patient, exportFields, patientStateJSON = this.parsePatientStateToJSON(patientState), groupName, remoteGUID, remoteServerIdentifier, remoteUserName, password, null);
        if (response != null && response.isSuccessful()) {
            this.storageManager.storePatientPushInfo(patient.getDocument().getName(), remoteServerIdentifier, response.getRemotePatientGUID(), response.getRemotePatientID(), response.getRemotePatientURL());
        }
        return response;
    }

    @Override
    public String getRemoteUsername(String remoteServerIdentifier) {
        RemoteLoginData storedData = this.getStoredData(remoteServerIdentifier);
        if (storedData == null) {
            return null;
        }
        return storedData.getRemoteUserName();
    }

    @Override
    public PushServerGetPatientIDResponse getPatientURL(String remoteServerIdentifier, String remotePatientGUID) {
        RemoteLoginData storedData = this.getStoredData(remoteServerIdentifier);
        if (storedData == null || storedData.getRemoteUserName() == null || storedData.getLoginToken() == null) {
            return new DefaultPushServerGetPatientIDResponse(DefaultPushServerResponse.generateIncorrectCredentialsJSON());
        }
        return this.internalService.getPatientURL(remoteServerIdentifier, remotePatientGUID, storedData.getRemoteUserName(), null, storedData.getLoginToken());
    }

    @Override
    public PushServerGetPatientIDResponse getPatientURL(String remoteServerIdentifier, String remotePatientGUID, String remoteUserName, String password) {
        return this.internalService.getPatientURL(remoteServerIdentifier, remotePatientGUID, remoteUserName, password, null);
    }

    private JSONObject parsePatientStateToJSON(String patientStateString) {
        try {
            JSONObject patientState = new JSONObject(patientStateString);
            return patientState;
        }
        catch (Exception ex) {
            return new JSONObject();
        }
    }
}

