/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.permissions.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import com.xpn.xwiki.store.migration.hibernate.HibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.phenotips.data.permissions.Visibility;
import org.phenotips.studies.family.Family;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component(roles={HibernateDataMigration.class})
@Named(value="R71509-PT-3476")
@Singleton
public class R71509PhenoTips3476DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> resolver;

    public String getDescription() {
        return "Adding a default 'private' visibility object to all families which did not have a visibility object #PT-3476";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(71509);
    }

    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), (XWikiHibernateBaseStore.HibernateCallback)new AddVisObjectCallback());
    }

    private final class AddVisObjectCallback
    implements XWikiHibernateBaseStore.HibernateCallback<Object> {
        private AddVisObjectCallback() {
        }

        public Object doInHibernate(Session session) throws HibernateException, XWikiException {
            XWikiContext context = R71509PhenoTips3476DataMigration.this.getXWikiContext();
            XWiki xwiki = context.getWiki();
            Query q = session.createQuery("select doc.fullName from XWikiDocument as doc, BaseObject as f where doc.fullName=f.name and f.className='" + (String)R71509PhenoTips3476DataMigration.this.serializer.serialize(Family.CLASS_REFERENCE, new Object[0]) + "' and not exists (from BaseObject visobj where visobj.className='" + (String)R71509PhenoTips3476DataMigration.this.serializer.serialize(Visibility.CLASS_REFERENCE, new Object[0]) + "' and  doc.fullName=visobj.name)");
            List documents = q.list();
            R71509PhenoTips3476DataMigration.this.logger.debug("Found {} family documents with no visibility object", (Object)documents.size());
            for (String docName : documents) {
                try {
                    R71509PhenoTips3476DataMigration.this.logger.debug("Checking [{}]", (Object)docName);
                    XWikiDocument doc = xwiki.getDocument(R71509PhenoTips3476DataMigration.this.resolver.resolve((Object)docName, new Object[0]), context);
                    if (doc == null) continue;
                    BaseObject visobj = doc.newXObject(Visibility.CLASS_REFERENCE, context);
                    visobj.set("visibility", (Object)"private", context);
                    doc.setComment(R71509PhenoTips3476DataMigration.this.getDescription());
                    doc.setMinorEdit(true);
                    session.clear();
                    ((XWikiHibernateStore)R71509PhenoTips3476DataMigration.this.getStore()).saveXWikiDoc(doc, context, false);
                    session.flush();
                    R71509PhenoTips3476DataMigration.this.logger.debug("Updated [{}]", (Object)docName);
                }
                catch (DataMigrationException dataMigrationException) {}
            }
            return null;
        }
    }
}

