/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.permissions.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import com.xpn.xwiki.store.migration.hibernate.HibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.phenotips.data.Patient;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component(roles={HibernateDataMigration.class})
@Named(value="71504-PT-3226")
@Singleton
public class R71504PhenoTips3226DataMigration
extends AbstractHibernateDataMigration
implements XWikiHibernateBaseStore.HibernateCallback<Object> {
    private static final EntityReference RIGHTS_CLASS = new EntityReference("XWikiRights", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    @Inject
    private Logger logger;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> resolver;

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), (XWikiHibernateBaseStore.HibernateCallback)this);
    }

    public String getDescription() {
        return "Search for documents with patients that have XWikiRights objects and remove the objects.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(71504);
    }

    public Object doInHibernate(Session session) throws HibernateException, XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        Query q = session.createQuery("select distinct doc.fullName from XWikiDocument as doc, BaseObject as p, BaseObject as r where p.name = doc.fullName and p.className = '" + (String)this.serializer.serialize(Patient.CLASS_REFERENCE, new Object[0]) + "' and r.name = doc.fullName and r.className = '" + (String)this.serializer.serialize(RIGHTS_CLASS, new Object[0]) + "'");
        List documents = q.list();
        this.logger.debug("Found {} patient documents", (Object)documents.size());
        for (String docName : documents) {
            try {
                this.logger.debug("Checking [{}]", (Object)docName);
                XWikiDocument doc = xwiki.getDocument(this.resolver.resolve((Object)docName, new Object[0]), context);
                if (doc == null) continue;
                doc.removeXObjects(RIGHTS_CLASS);
                doc.setComment(this.getDescription());
                doc.setMinorEdit(true);
                session.clear();
                ((XWikiHibernateStore)this.getStore()).saveXWikiDoc(doc, context, false);
                session.flush();
                this.logger.debug("Updated [{}]", (Object)docName);
            }
            catch (DataMigrationException dataMigrationException) {}
        }
        return null;
    }
}

