/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.permissions.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import com.xpn.xwiki.store.migration.hibernate.HibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.phenotips.data.Patient;
import org.phenotips.data.permissions.Owner;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component(roles={HibernateDataMigration.class})
@Named(value="R54590Phenotips#931")
@Singleton
public class R54590PhenoTips931DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public String getDescription() {
        return "Add a PhenoTips.OwnerClass to all patient records that don't have one";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(54590);
    }

    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), (XWikiHibernateBaseStore.HibernateCallback)new AddOwnerCallback());
    }

    private class AddOwnerCallback
    implements XWikiHibernateBaseStore.HibernateCallback<Object> {
        private AddOwnerCallback() {
        }

        public Object doInHibernate(Session session) throws HibernateException, XWikiException {
            XWikiContext context = R54590PhenoTips931DataMigration.this.getXWikiContext();
            XWiki xwiki = context.getWiki();
            String pclass = (String)R54590PhenoTips931DataMigration.this.serializer.serialize(Patient.CLASS_REFERENCE, new Object[0]);
            String oclass = (String)R54590PhenoTips931DataMigration.this.serializer.serialize(Owner.CLASS_REFERENCE, new Object[0]);
            Query q = session.createQuery("select distinct doc.fullName from XWikiDocument doc, BaseObject p where p.name = doc.fullName and p.className = '" + pclass + "' and doc.name <> 'PatientTemplate' and not exists (from BaseObject o where o.name = doc.fullName and o.className = '" + oclass + "')");
            List documents = q.list();
            for (String docName : documents) {
                try {
                    XWikiDocument doc = xwiki.getDocument(R54590PhenoTips931DataMigration.this.resolver.resolve((Object)docName, new Object[0]), context);
                    if (doc == null) continue;
                    BaseObject owner = doc.newXObject(Owner.CLASS_REFERENCE, context);
                    if (doc.getCreatorReference() == null) {
                        owner.setStringValue("owner", "");
                    } else {
                        owner.setStringValue("owner", (String)R54590PhenoTips931DataMigration.this.serializer.serialize((EntityReference)doc.getCreatorReference(), new Object[0]));
                    }
                    doc.setMinorEdit(true);
                    doc.setMetaDataDirty(false);
                    doc.setContentDirty(false);
                    session.clear();
                    ((XWikiHibernateStore)R54590PhenoTips931DataMigration.this.getStore()).saveXWikiDoc(doc, context, false);
                    session.flush();
                }
                catch (DataMigrationException doc) {
                }
                catch (XWikiException ex) {
                    R54590PhenoTips931DataMigration.this.logger.warn("Failed to add owner object to patient [{}]: {}", (Object)docName, (Object)ex.getMessage());
                }
            }
            return null;
        }
    }
}

