/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.data.permissions.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import com.xpn.xwiki.store.migration.hibernate.HibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.phenotips.data.permissions.Visibility;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component(roles={HibernateDataMigration.class})
@Named(value="R54692PhenoTips#1378")
@Singleton
public class R54692PhenoTips1378DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> resolver;

    public String getDescription() {
        return "Adding a default 'private' visibility object to all patients which did not have a visibility object #1378";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(54692);
    }

    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), (XWikiHibernateBaseStore.HibernateCallback)new AddVisObjectCallback());
    }

    private final class AddVisObjectCallback
    implements XWikiHibernateBaseStore.HibernateCallback<Object> {
        private AddVisObjectCallback() {
        }

        public Object doInHibernate(Session session) throws HibernateException, XWikiException {
            XWikiContext context = R54692PhenoTips1378DataMigration.this.getXWikiContext();
            XWiki xwiki = context.getWiki();
            Query q = session.createQuery("select doc.fullName from XWikiDocument as doc, BaseObject as patobj where doc.fullName=patobj.name and patobj.className='PhenoTips.PatientClass' and not exists(from BaseObject visobj where visobj.className='PhenoTips.VisibilityClass' and doc.fullName=visobj.name)");
            List documents = q.list();
            R54692PhenoTips1378DataMigration.this.logger.debug("Found {} documents with no visibility object", (Object)documents.size());
            for (String docName : documents) {
                try {
                    R54692PhenoTips1378DataMigration.this.logger.debug("Checking [{}]", (Object)docName);
                    XWikiDocument doc = xwiki.getDocument(R54692PhenoTips1378DataMigration.this.resolver.resolve((Object)docName, new Object[0]), context);
                    if (doc == null) continue;
                    BaseObject visobj = doc.newXObject(Visibility.CLASS_REFERENCE, context);
                    visobj.set("visibility", (Object)"private", context);
                    doc.setComment(R54692PhenoTips1378DataMigration.this.getDescription());
                    doc.setMinorEdit(true);
                    session.clear();
                    ((XWikiHibernateStore)R54692PhenoTips1378DataMigration.this.getStore()).saveXWikiDoc(doc, context, false);
                    session.flush();
                    R54692PhenoTips1378DataMigration.this.logger.debug("Updated [{}]", (Object)docName);
                }
                catch (DataMigrationException e) {}
            }
            return null;
        }
    }
}

