/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.ncbieutils.internal;

import java.io.BufferedInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.phenotips.ncbieutils.NCBIEUtilsService;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSpecializedNCBIEUtilsAccessService
implements NCBIEUtilsService {
    @Inject
    private Logger logger;
    protected static final String SERVER_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/";
    protected static final String TERM_SEARCH_QUERY_SCRIPT = "esearch.fcgi";
    protected static final String TERM_SEARCH_PARAM_NAME = "term";
    protected static final String TERM_SUMMARY_QUERY_SCRIPT = "esummary.fcgi";
    protected static final String TERM_SUMMARY_PARAM_NAME = "id";
    protected static final String SPELL_CHECK_QUERY_SCRIPT = "espell.fcgi";
    protected static final String SPELL_CHECK_PARAM_NAME = "term";
    protected static final String DB_PARAM_NAME = "db";

    protected abstract String getDatabaseName();

    @Override
    public List<Map<String, Object>> getSuggestions(String query) {
        return this.getSuggestions(query, 10, 0);
    }

    @Override
    public List<Map<String, Object>> getSuggestions(String query, int rows, int start) {
        String correctedQuery = this.getCorrectedQuery(query);
        List<String> idList = this.getMatches(correctedQuery, rows, start);
        List<Map<String, Object>> result = this.getSummaries(idList);
        return result;
    }

    @Override
    public String getSuggestionsXML(String query) {
        return this.getSuggestionsXML(query, 10, 0);
    }

    @Override
    public String getSuggestionsXML(String query, int rows, int start) {
        String correctedQuery = this.getCorrectedQuery(query);
        List<String> idList = this.getMatches(correctedQuery, rows, start);
        String result = this.getSummariesXML(idList);
        return result;
    }

    @Override
    public String getName(String id) {
        String url = this.composeURL(TERM_SUMMARY_QUERY_SCRIPT, TERM_SUMMARY_PARAM_NAME, id);
        String result = id;
        try {
            Map<String, String> idToName;
            Document response = this.readXML(url);
            NodeList nodes = response.getElementsByTagName("DocSum");
            if (nodes.getLength() > 0 && (result = (idToName = this.getNameForId(nodes.item(0))).get(id)) != null && !id.equals(result)) {
                return result;
            }
            this.logger.warn("Name not found for OMIM id " + id);
            return id;
        }
        catch (Exception ex) {
            this.logger.error("Error while trying to retrieve name for " + this.getDatabaseName() + " id " + id + " " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
            return id;
        }
    }

    @Override
    public Map<String, String> getNames(List<String> idList) {
        HashMap<String, String> result = new HashMap<String, String>();
        String queryList = AbstractSpecializedNCBIEUtilsAccessService.getSerializedList(idList);
        String url = this.composeURL(TERM_SUMMARY_QUERY_SCRIPT, TERM_SUMMARY_PARAM_NAME, queryList);
        try {
            Document response = this.readXML(url);
            NodeList nodes = response.getElementsByTagName("DocSum");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Map<String, String> idToName = this.getNameForId(nodes.item(i));
                for (String id : idToName.keySet()) {
                    if (idList.contains(id)) {
                        result.put(id, idToName.get(id));
                        continue;
                    }
                    this.logger.warn("Unrequested " + this.getDatabaseName() + " id " + id);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Error while trying to retrieve name for " + this.getDatabaseName() + " ids " + queryList + " " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    @Override
    public String getCorrectedQuery(String query) {
        String url = this.composeURL(SPELL_CHECK_QUERY_SCRIPT, "term", query);
        try {
            Document response = this.readXML(url);
            NodeList nodes = response.getElementsByTagName("CorrectedQuery");
            if (nodes.getLength() > 0) {
                String result = nodes.item(0).getTextContent();
                return StringUtils.isNotEmpty((CharSequence)(result = StringUtils.trim((String)result))) ? result : query;
            }
        }
        catch (Exception ex) {
            this.logger.error("Error while trying to retrieve corrected query for " + query + " " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
        }
        return query;
    }

    @Override
    public List<String> getMatches(String query, int rows, int start) {
        String url = this.composeURL(TERM_SEARCH_QUERY_SCRIPT, "term", query, rows, start);
        ArrayList<String> result = new ArrayList<String>();
        try {
            Document response = this.readXML(url);
            NodeList nodes = response.getElementsByTagName("IdList");
            if (nodes.getLength() > 0) {
                nodes = nodes.item(0).getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node n = nodes.item(i);
                    if (n.getNodeType() != 1 || !n.getNodeName().equals("Id")) continue;
                    result.add(n.getTextContent());
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Error while trying to retrieve matches for " + query + " " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> getSummaries(List<String> idList) {
        String queryList = AbstractSpecializedNCBIEUtilsAccessService.getSerializedList(idList);
        String url = this.composeURL(TERM_SUMMARY_QUERY_SCRIPT, TERM_SUMMARY_PARAM_NAME, queryList);
        try {
            Document response = this.readXML(url);
            NodeList nodes = response.getElementsByTagName("Item");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (n.getNodeType() != 1 || n.getFirstChild() == null) continue;
                n.replaceChild(response.createTextNode(AbstractSpecializedNCBIEUtilsAccessService.fixCase(n.getTextContent())), n.getFirstChild());
            }
            LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
            nodes = response.getElementsByTagName("DocSum");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element n = (Element)nodes.item(i);
                HashMap<String, Object> doc = new HashMap<String, Object>();
                doc.put(TERM_SUMMARY_PARAM_NAME, n.getElementsByTagName("Id").item(0).getTextContent());
                NodeList items = n.getElementsByTagName("Item");
                for (int j = 0; j < items.getLength(); ++j) {
                    Element item = (Element)items.item(j);
                    if ("List".equals(item.getAttribute("Type"))) {
                        NodeList subitems = item.getElementsByTagName("Item");
                        if (subitems.getLength() <= 0) continue;
                        ArrayList<String> values = new ArrayList<String>(subitems.getLength());
                        for (int k = 0; k < subitems.getLength(); ++k) {
                            values.add(subitems.item(k).getTextContent());
                        }
                        doc.put(item.getAttribute("Name"), values);
                        continue;
                    }
                    String value = item.getTextContent();
                    if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                    doc.put(item.getAttribute("Name"), value);
                }
                result.add(doc);
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.error("Error while trying to retrieve summaries for ids " + idList + " " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    protected String getSummariesXML(List<String> idList) {
        String queryList = AbstractSpecializedNCBIEUtilsAccessService.getSerializedList(idList);
        String url = this.composeURL(TERM_SUMMARY_QUERY_SCRIPT, TERM_SUMMARY_PARAM_NAME, queryList);
        try {
            Document response = this.readXML(url);
            NodeList nodes = response.getElementsByTagName("Item");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (n.getNodeType() != 1 || n.getFirstChild() == null) continue;
                n.replaceChild(response.createTextNode(AbstractSpecializedNCBIEUtilsAccessService.fixCase(n.getTextContent())), n.getFirstChild());
            }
            DOMSource source = new DOMSource(response);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception ex) {
            this.logger.error("Error while trying to retrieve summaries for ids " + idList + " " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
            return "";
        }
    }

    private Map<String, String> getNameForId(Node source) {
        HashMap<String, String> result = new HashMap<String, String>();
        String id = null;
        String name = null;
        NodeList data = source.getChildNodes();
        for (int i = 0; i < data.getLength(); ++i) {
            NamedNodeMap attrs;
            Node n = data.item(i);
            if (n.getNodeType() != 1) continue;
            if ("Id".equals(n.getNodeName())) {
                id = n.getTextContent();
                continue;
            }
            if (!"Item".equals(n.getNodeName()) || (attrs = n.getAttributes()).getNamedItem("Name") == null || !"Title".equals(attrs.getNamedItem("Name").getNodeValue())) continue;
            name = n.getTextContent();
        }
        if (id != null) {
            if (name != null) {
                result.put(id, AbstractSpecializedNCBIEUtilsAccessService.fixCase(name));
            } else {
                result.put(id, id);
            }
        }
        return result;
    }

    private String composeURL(String scriptName, String paramName, String query) {
        try {
            return SERVER_URL + scriptName + "?" + DB_PARAM_NAME + '=' + this.getDatabaseName() + "&" + paramName + "=" + URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return SERVER_URL + scriptName + "?" + DB_PARAM_NAME + '=' + this.getDatabaseName() + "&" + paramName + "=" + query;
        }
    }

    private String composeURL(String scriptName, String paramName, String query, int rows, int start) {
        try {
            return SERVER_URL + scriptName + "?" + DB_PARAM_NAME + '=' + this.getDatabaseName() + "&" + paramName + "=" + URLEncoder.encode(query, "UTF-8") + "&RetMax=" + rows + "&RetStart=" + start;
        }
        catch (UnsupportedEncodingException ex) {
            return SERVER_URL + scriptName + "?" + DB_PARAM_NAME + '=' + this.getDatabaseName() + "&" + paramName + "=" + query + "&RetMax=" + rows + "&RetStart=" + start;
        }
    }

    private Document readXML(String url) {
        try {
            BufferedInputStream in = new BufferedInputStream(new URL(url).openStream());
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document result = dBuilder.parse(in);
            result.getDocumentElement().normalize();
            return result;
        }
        catch (Exception ex) {
            this.logger.error("Error while trying to retrieve data from URL " + url + " " + ex.getClass().getName() + " " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static String fixCase(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        if (StringUtils.isAllUpperCase((CharSequence)text.replaceAll("[^a-zA-Z]", ""))) {
            return StringUtils.capitalize((String)text.toLowerCase());
        }
        return text;
    }

    private static String getSerializedList(List<String> list) {
        String result = "";
        if (!list.isEmpty()) {
            StringBuilder listBuilder = new StringBuilder();
            for (String item : list) {
                listBuilder.append(',').append(item);
            }
            result = listBuilder.substring(1);
        }
        return result;
    }
}

