/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.messaging;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.phenotips.components.ComponentManagerRegistry;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

public class DocumentReferenceType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Class<?> returnedClass() {
        return DocumentReference.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (DocumentReference.class.isInstance(x) && DocumentReference.class.isInstance(y)) {
            return x.equals(y);
        }
        return false;
    }

    public int hashCode(Object x) throws HibernateException {
        if (DocumentReference.class.isInstance(x)) {
            DocumentReference reference = (DocumentReference)x;
            return reference.hashCode();
        }
        return 0;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String serializedReference = rs.getString(names[0]);
        return this.resolve(serializedReference);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (DocumentReference.class.isInstance(value)) {
            st.setString(index, value.toString());
        } else {
            st.setNull(index, 12);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return String.valueOf(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (String.class.isInstance(cached)) {
            return this.resolve((String)((Object)cached));
        }
        return null;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    private DocumentReference resolve(String serializedReference) {
        if (StringUtils.isNotEmpty((CharSequence)serializedReference)) {
            try {
                DocumentReferenceResolver resolver = (DocumentReferenceResolver)ComponentManagerRegistry.getContextComponentManager().getInstance((Type)DocumentReferenceResolver.TYPE_STRING);
                return resolver.resolve((Object)serializedReference, new Object[0]);
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
        }
        return null;
    }
}

