/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.messaging.internal;

import com.xpn.xwiki.store.hibernate.HibernateSessionFactory;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hibernate.Criteria;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.phenotips.data.similarity.PatientSimilarityView;
import org.phenotips.data.similarity.PatientSimilarityViewFactory;
import org.phenotips.messaging.Connection;
import org.phenotips.messaging.ConnectionManager;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
public class DefaultConnectionManager
implements ConnectionManager {
    @Inject
    private HibernateSessionFactory sessionFactory;
    @Inject
    private PatientSimilarityViewFactory publicPatientSimilarityViewFactory;

    @Override
    public Connection getConnection(PatientSimilarityView patientPair) {
        Session session = this.sessionFactory.getSessionFactory().openSession();
        Criteria c = session.createCriteria(Connection.class);
        Connection connection = new Connection(this.publicPatientSimilarityViewFactory.convert(patientPair));
        c.add((Criterion)Example.create((Object)connection).excludeProperty("id"));
        List foundEntries = c.list();
        if (foundEntries.isEmpty()) {
            Transaction t = session.beginTransaction();
            t.begin();
            session.save((Object)connection);
            t.commit();
            return connection;
        }
        return (Connection)foundEntries.get(0);
    }

    @Override
    public Connection getConnectionById(Long id) {
        Session session = this.sessionFactory.getSessionFactory().openSession();
        return (Connection)session.createQuery("select c from " + Connection.class.getCanonicalName() + " as c where c.id = " + id).uniqueResult();
    }

    @Override
    public Connection getConnectionByToken(String token) {
        Session session = this.sessionFactory.getSessionFactory().openSession();
        return (Connection)session.load(Connection.class, (Serializable)UUID.fromString(token));
    }
}

