/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.messaging.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.mailsender.Mail;
import com.xpn.xwiki.plugin.mailsender.MailSenderPlugin;
import com.xpn.xwiki.web.Utils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import org.hibernate.Session;
import org.phenotips.data.permissions.AccessLevel;
import org.phenotips.data.permissions.PermissionsManager;
import org.phenotips.matchingnotification.match.PatientMatch;
import org.phenotips.matchingnotification.storage.MatchStorageManager;
import org.phenotips.messaging.ActionManager;
import org.phenotips.messaging.Connection;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
public class DefaultActionManager
implements ActionManager {
    private static final String MAIL_SENDER = "mailsender";
    private static final String GROUP_EMAIL = "contact";
    private static final String EMAIL = "email";
    private static final String RECIPIENT_NAME = "recipientName";
    private static final String CONTACTED_USER_NAME = "contactedUserName";
    private static final String MATCH_CASE_ID = "matchCaseId";
    private static final String MATCH_CASE_LINK = "matchCaseAccessLink";
    private static final String PHENOMECENTRAL_EMAIL = "PhenomeCentral <noreply@phenomecentral.org>";
    private static final String FAILED_MAIL_MSG = "Failed to send email: [{}]";
    private static final String EXTERNAL_LINK_MODE = "view";
    private static final String PLATFORM = "PhenomeCentral";
    private static final String SUBJECT = "Access to patient record granted";
    private static final String SUBJECT_FIELD_STRING = "subject";
    private static final String OPTIONS_MESSAGE_FIELD = "message";
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    @Named(value="view")
    private AccessLevel defaultAccess;
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    @Named(value="manage")
    private AccessLevel manageAccessLevel;
    @Inject
    private MatchStorageManager matchStorageManager;
    @Inject
    private Logger logger;

    @Override
    public int sendInitialMails(Connection connection, Map<String, Object> options) {
        try {
            XWikiContext context = Utils.getContext();
            XWiki xwiki = context.getWiki();
            MailSenderPlugin mailsender = (MailSenderPlugin)xwiki.getPlugin(MAIL_SENDER, context);
            String to = this.getEmail(connection.getContactedUser());
            String replyTo = this.getEmail(connection.getInitiatingUser());
            Mail mail = new Mail();
            mail.setTo(to);
            mail.setHeader("Reply-To", replyTo);
            mail.setHeader("Return-Path", replyTo);
            mail.setFrom(PHENOMECENTRAL_EMAIL);
            mail.setCc(this.getEmail(connection.getInitiatingUser()));
            mail.setBcc("qc@phenomecentral.org");
            mail.setTextPart((String)options.get(OPTIONS_MESSAGE_FIELD));
            mail.setSubject((String)options.get(SUBJECT_FIELD_STRING));
            mailsender.sendMail(mail, context);
            this.setNotified((String)options.get("patientId"), (String)options.get("matchId"));
            return 0;
        }
        catch (MessagingException e) {
            this.logger.error(FAILED_MAIL_MSG, (Object)e.getMessage(), (Object)e);
            return 500;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(FAILED_MAIL_MSG, (Object)e.getMessage(), (Object)e);
            return 400;
        }
    }

    @Override
    public int grantAccess(Connection connection) {
        if (!this.permissionsManager.getPatientAccess(connection.getTargetPatient()).addCollaborator((EntityReference)connection.getInitiatingUser(), this.defaultAccess)) {
            return 1;
        }
        if (!this.permissionsManager.getPatientAccess(connection.getReferencePatient()).addCollaborator((EntityReference)connection.getContactedUser(), this.defaultAccess)) {
            return 2;
        }
        return 0;
    }

    @Override
    public int sendSuccessMail(Connection connection) {
        try {
            HashMap<String, String> options = new HashMap<String, String>();
            XWikiContext context = Utils.getContext();
            XWiki xwiki = context.getWiki();
            MailSenderPlugin mailsender = (MailSenderPlugin)xwiki.getPlugin(MAIL_SENDER, context);
            String to = this.getEmail(connection.getInitiatingUser());
            options.put("platformName", PLATFORM);
            options.put(SUBJECT_FIELD_STRING, SUBJECT);
            options.put(RECIPIENT_NAME, xwiki.getUserName(connection.getInitiatingUser().toString(), null, false, context));
            options.put(CONTACTED_USER_NAME, xwiki.getUserName(connection.getContactedUser().toString(), null, false, context));
            options.put(MATCH_CASE_ID, connection.getTargetPatient().getDocument().getName());
            options.put("matchCaseReferenceId", connection.getReferencePatient().getDocument().getName());
            options.put(MATCH_CASE_LINK, xwiki.getDocument(connection.getTargetPatient().getDocument(), context).getExternalURL(EXTERNAL_LINK_MODE, context));
            options.put("matchCaseReferenceLink", xwiki.getDocument(connection.getReferencePatient().getDocument(), context).getExternalURL(EXTERNAL_LINK_MODE, context));
            mailsender.sendMailFromTemplate("PhenoTips.MatchSuccessContact", PHENOMECENTRAL_EMAIL, to, null, null, "", options, context);
            return 0;
        }
        catch (Exception ex) {
            this.logger.error(FAILED_MAIL_MSG, (Object)ex.getMessage(), (Object)ex);
            return 1;
        }
    }

    private String getEmail(DocumentReference userDocument) {
        String email = "";
        try {
            XWikiDocument doc = (XWikiDocument)this.bridge.getDocument(userDocument);
            email = "Groups".equals(userDocument.getLastSpaceReference().getName()) ? doc.getStringValue(GROUP_EMAIL) : doc.getStringValue(EMAIL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return email;
    }

    private void setNotified(String patientId, String matchId) {
        LinkedList<PatientMatch> successfulMatches = new LinkedList<PatientMatch>();
        List matchesForPatient = this.matchStorageManager.loadMatchesByReferencePatientId(patientId);
        for (PatientMatch match : matchesForPatient) {
            if (!match.getMatchedPatientId().equals(matchId)) continue;
            successfulMatches.add(match);
            break;
        }
        Session session = this.matchStorageManager.beginNotificationMarkingTransaction();
        this.matchStorageManager.markNotified(session, successfulMatches);
        this.matchStorageManager.endNotificationMarkingTransaction(session);
    }
}

