/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.messaging;

import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.phenotips.components.ComponentManagerRegistry;
import org.phenotips.data.Patient;
import org.phenotips.data.permissions.PatientAccess;
import org.phenotips.data.permissions.PermissionsManager;
import org.phenotips.data.similarity.PatientSimilarityView;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.users.UserManager;

@Entity
public class Connection {
    @Id
    @GeneratedValue(generator="uuid2")
    @GenericGenerator(name="uuid2", strategy="uuid2")
    @Column(name="uuid", columnDefinition="BINARY(16)")
    private UUID token;
    private long id;
    @Type(type="org.phenotips.messaging.DocumentReferenceType")
    private DocumentReference initiatingUser;
    @Type(type="org.phenotips.messaging.DocumentReferenceType")
    private DocumentReference contactedUser;
    @Type(type="org.phenotips.messaging.PatientReferenceType")
    private Patient referencePatient;
    @Type(type="org.phenotips.messaging.PatientReferenceType")
    private Patient targetPatient;

    public Connection() {
    }

    public Connection(PatientSimilarityView patientPair) {
        this.targetPatient = patientPair;
        this.referencePatient = patientPair.getReference();
        PatientAccess pa = this.getAccess(patientPair.getReference());
        this.initiatingUser = this.getUserManager().getCurrentUser().getProfileDocument();
        pa = this.getAccess((Patient)patientPair);
        this.contactedUser = new DocumentReference(pa.getOwner().getUser());
    }

    @Deprecated
    public Long getId() {
        return this.id;
    }

    public String getToken() {
        return String.valueOf(this.token);
    }

    public DocumentReference getInitiatingUser() {
        return this.initiatingUser;
    }

    public void setInitiatingUser(DocumentReference userReference) {
        this.initiatingUser = userReference;
    }

    public DocumentReference getContactedUser() {
        return this.contactedUser;
    }

    public void setContactedUser(DocumentReference userReference) {
        this.contactedUser = userReference;
    }

    public Patient getReferencePatient() {
        return this.referencePatient;
    }

    public void setReferencePatient(Patient patient) {
        this.referencePatient = patient;
    }

    public Patient getTargetPatient() {
        return this.targetPatient;
    }

    public void setTargetPatient(Patient patient) {
        this.targetPatient = patient;
    }

    public String toString() {
        return this.getToken();
    }

    private PatientAccess getAccess(Patient p) {
        PermissionsManager pm = (PermissionsManager)this.getComponent((java.lang.reflect.Type)((Object)PermissionsManager.class));
        return pm.getPatientAccess(p);
    }

    private <T> T getComponent(java.lang.reflect.Type type) {
        try {
            return (T)ComponentManagerRegistry.getContextComponentManager().getInstance(type);
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    private UserManager getUserManager() {
        try {
            return (UserManager)ComponentManagerRegistry.getContextComponentManager().getInstance(UserManager.class);
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }
}

