/*
 * Decompiled with CFR 0.152.
 */
package org.phenotips.messaging;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.phenotips.components.ComponentManagerRegistry;
import org.phenotips.data.Patient;
import org.phenotips.data.PatientRepository;
import org.xwiki.component.manager.ComponentLookupException;

public class PatientReferenceType
implements UserType {
    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Class<?> returnedClass() {
        return Patient.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (Patient.class.isInstance(x) && Patient.class.isInstance(y)) {
            return x.equals(y);
        }
        return false;
    }

    public int hashCode(Object x) throws HibernateException {
        if (Patient.class.isInstance(x)) {
            return x.hashCode();
        }
        return 0;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String serializedReference = rs.getString(names[0]);
        if (StringUtils.isNotEmpty((CharSequence)serializedReference)) {
            return this.resolvePatient(serializedReference);
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (Patient.class.isInstance(value)) {
            st.setString(index, ((Patient)value).getDocument().toString());
        } else {
            st.setNull(index, 12);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (Patient.class.isInstance(value)) {
            return ((Patient)value).getDocument().toString();
        }
        return null;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (String.class.isInstance(cached)) {
            return this.resolvePatient((String)((Object)cached));
        }
        return null;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    private Patient resolvePatient(String serializedReference) {
        try {
            PatientRepository resolver = (PatientRepository)ComponentManagerRegistry.getContextComponentManager().getInstance(PatientRepository.class);
            return resolver.getPatientById(serializedReference);
        }
        catch (ComponentLookupException componentLookupException) {
            return null;
        }
    }
}

