/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.osxappbundle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:osxappbundle-maven-plugin:1.0-alpha-4-sdumitriu", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven OS X Application Bundle Plugin", 0);
        this.append(sb, "A Maven Plugin for generating Mac OS X Application Bundles of Java applications and packaging them as a DMG disk image.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "bundle".equals(this.goal)) {
            this.append(sb, "osxappbundle:bundle", 0);
            this.append(sb, "Package dependencies as an Application Bundle for Mac OS X.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalClasspath", 2);
                this.append(sb, "Paths to be put on the classpath in addition to the projects dependencies. Might be useful to specify locations of dependencies in the provided scope that are not distributed with the bundle but have a known location on the system. http://jira.codehaus.org/browse/MOJO-874", 3);
                this.append(sb, "", 0);
                this.append(sb, "additionalResources", 2);
                this.append(sb, "Additional resources (as a list of FileSet objects) that will be copies into the build directory and included in the .dmg and .zip files alongside with the application bundle.", 3);
                this.append(sb, "", 0);
                this.append(sb, "buildDirectory (Default: ${project.build.directory}/${project.build.finalName})", 2);
                this.append(sb, "The directory where the application bundle will be created", 3);
                this.append(sb, "", 0);
                this.append(sb, "bundleName (Default: ${project.name})", 2);
                this.append(sb, "The name of the Bundle. This is the name that is given to the application bundle; and it is also what will show up in the application menu, dock etc.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "dictionaryFile (Default: org/codehaus/mojo/osxappbundle/Info.plist.template)", 2);
                this.append(sb, "The location of the template for Info.plist. Classpath is checked before the file system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "diskImageFile (Default: ${project.build.directory}/${project.build.finalName}.dmg)", 2);
                this.append(sb, "The location of the generated disk image file", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludeArtifactIds", 2);
                this.append(sb, "Comma separated list of ArtifactIds to exclude from the dependency copy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "iconFile", 2);
                this.append(sb, "The icon file for the bundle", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeApplicationsSymlink (Default: false)", 2);
                this.append(sb, "Should a link to the Applications folder be created?", 3);
                this.append(sb, "", 0);
                this.append(sb, "internetEnable (Default: false)", 2);
                this.append(sb, "If this is set to true, the generated DMG file will be internet-enabled. The default is ${false}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaApplicationStub (Default: /System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub)", 2);
                this.append(sb, "The location of the Java Application Stub", 3);
                this.append(sb, "", 0);
                this.append(sb, "jvmVersion (Default: 1.4+)", 2);
                this.append(sb, "A value for the JVMVersion key.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mainClass", 2);
                this.append(sb, "The main class to execute when double-clicking the Application Bundle", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${mainClass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: ${project.version})", 2);
                this.append(sb, "The version of the project. Will be used as the value of the CFBundleVersion key.", 3);
                this.append(sb, "", 0);
                this.append(sb, "vmOptions", 2);
                this.append(sb, "Options to the JVM, will be used as the value of VMOptions in Info.plist.", 3);
                this.append(sb, "", 0);
                this.append(sb, "volumeBackgroundFile", 2);
                this.append(sb, "The image file for the DMG background image.", 3);
                this.append(sb, "", 0);
                this.append(sb, "volumeIconFile", 2);
                this.append(sb, "The icon file for the DMG image.", 3);
                this.append(sb, "", 0);
                this.append(sb, "volumeLabel", 2);
                this.append(sb, "The label of the volume. This is the name that will appear in Finder when mounting the disk image.", 3);
                this.append(sb, "", 0);
                this.append(sb, "zipFile (Default: ${project.build.directory}/${project.build.finalName}-app.zip)", 2);
                this.append(sb, "The location of the produced Zip file containing the bundle.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "osxappbundle:help", 0);
            this.append(sb, "Display help information on osxappbundle-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0osxappbundle:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

