/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.osxappbundle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.mojo.osxappbundle.FileSet;
import org.codehaus.mojo.osxappbundle.encoding.DefaultEncodingDetector;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.velocity.VelocityComponent;

public class CreateApplicationBundleMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private MavenProject project;
    private File buildDirectory;
    private File diskImageFile;
    private File javaApplicationStub;
    private String mainClass;
    private String bundleName;
    private File iconFile;
    private String volumeLabel;
    private File volumeIconFile;
    private File volumeBackgroundFile;
    private boolean includeApplicationsSymlink;
    private String version;
    private String jvmVersion;
    private File zipFile;
    private List additionalClasspath;
    private List additionalResources;
    private VelocityComponent velocity;
    private String dictionaryFile;
    private String vmOptions;
    private MavenProjectHelper projectHelper;
    private ZipArchiver zipArchiver;
    private boolean internetEnable;
    private Set excludeArtifactIds;
    private static final String[] SET_FILE_LOCATIONS = new String[]{"/usr/bin/SetFile", "/Developer/Tools/SetFile", "/Applications/Xcode.app/Contents/Developer/Tools/SetFile"};
    private String setFilePath;

    public CreateApplicationBundleMojo() {
        for (int i = 0; i < SET_FILE_LOCATIONS.length; ++i) {
            if (!new File(SET_FILE_LOCATIONS[i]).exists()) continue;
            this.setFilePath = SET_FILE_LOCATIONS[i];
            break;
        }
    }

    public void execute() throws MojoExecutionException {
        this.buildDirectory.mkdirs();
        File bundleDir = new File(this.buildDirectory, this.cleanBundleName(this.bundleName) + ".app");
        bundleDir.mkdirs();
        File contentsDir = new File(bundleDir, "Contents");
        contentsDir.mkdirs();
        File resourcesDir = new File(contentsDir, "Resources");
        resourcesDir.mkdirs();
        File javaDirectory = new File(resourcesDir, "Java");
        javaDirectory.mkdirs();
        File macOSDirectory = new File(contentsDir, "MacOS");
        macOSDirectory.mkdirs();
        File stub = new File(macOSDirectory, this.javaApplicationStub.getName());
        if (!this.javaApplicationStub.exists()) {
            String message = "Can't find JavaApplicationStub binary. File does not exist: " + this.javaApplicationStub;
            if (!this.isOsX()) {
                message = message + "\nNOTICE: You are running the osxappbundle plugin on a non OS X platform. To make this work you need to copy the JavaApplicationStub binary into your source tree. Then configure it with the 'javaApplicationStub' configuration property.\nOn an OS X machine, the JavaApplicationStub is typically located under /System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub";
            }
            throw new MojoExecutionException(message);
        }
        try {
            FileUtils.copyFile((File)this.javaApplicationStub, (File)stub);
            Commandline chmod = new Commandline();
            chmod.setExecutable("chmod");
            chmod.createArgument().setValue("755");
            chmod.createArgument().setFile(stub);
            chmod.execute();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy file " + this.javaApplicationStub + " to directory " + macOSDirectory, (Exception)e);
        }
        catch (CommandLineException e) {
            this.getLog().warn((CharSequence)"Failed to mark the Java stub as executable, application may not run properly.");
        }
        if (this.iconFile != null) {
            try {
                FileUtils.copyFileToDirectory((File)this.iconFile, (File)resourcesDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file " + this.iconFile + " to " + resourcesDir, (Exception)e);
            }
        }
        List files = this.copyDependencies(javaDirectory);
        File infoPlist = new File(bundleDir, "Contents/Info.plist");
        this.writeInfoPlist(infoPlist, files);
        if (this.additionalResources != null && !this.additionalResources.isEmpty()) {
            this.copyResources(this.additionalResources);
        }
        this.createZip();
        if (this.isOsX()) {
            if (this.volumeIconFile != null) {
                try {
                    this.getLog().info((CharSequence)"Copying volume icon file");
                    FileUtils.copyFile((File)this.volumeIconFile, (File)new File(this.buildDirectory, ".VolumeIcon.icns"));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error copying file " + this.volumeIconFile + " to " + this.buildDirectory, (Exception)e);
                }
            }
            if (this.volumeBackgroundFile != null) {
                try {
                    this.getLog().info((CharSequence)"Copying volume background file");
                    File backgroundDirectory = new File(this.buildDirectory, ".background");
                    backgroundDirectory.mkdirs();
                    FileUtils.copyFile((File)this.volumeBackgroundFile, (File)new File(backgroundDirectory, "background.png"));
                    this.setFileAttributes(backgroundDirectory, "V");
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error copying file " + this.volumeBackgroundFile + " to " + this.buildDirectory, (Exception)e);
                }
            }
            if (this.includeApplicationsSymlink) {
                Commandline link = new Commandline();
                try {
                    link.setExecutable("ln");
                    link.createArgument().setValue("-s");
                    link.createArgument().setValue("/Applications");
                    link.createArgument().setFile(new File(this.buildDirectory, " "));
                    link.execute().waitFor();
                }
                catch (CommandLineException e) {
                    throw new MojoExecutionException("Error executing " + link + " ", (Exception)((Object)e));
                }
                catch (InterruptedException e) {
                    throw new MojoExecutionException("Error executing " + link + " ", (Exception)e);
                }
            }
            this.setFileAttributes(bundleDir, "B");
            this.createDMG();
        }
    }

    private String cleanBundleName(String bundleName) {
        return bundleName.replace(':', '-');
    }

    private boolean isOsX() {
        return System.getProperty("mrj.version") != null;
    }

    private List copyDependencies(File javaDirectory) throws MojoExecutionException {
        DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
        ArrayList<String> list = new ArrayList<String>();
        File repoDirectory = new File(javaDirectory, "repo");
        repoDirectory.mkdirs();
        File artifactFile = this.project.getArtifact().getFile();
        if (artifactFile != null) {
            list.add(repoDirectory.getName() + "/" + layout.pathOf(this.project.getArtifact()));
            try {
                FileUtils.copyFile((File)artifactFile, (File)new File(repoDirectory, layout.pathOf(this.project.getArtifact())));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy artifact file " + artifactFile + " to " + javaDirectory);
            }
        }
        Set artifacts = this.project.getArtifacts();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            String artifactId = artifact.getArtifactId();
            if (this.excludeArtifactIds != null && this.excludeArtifactIds.contains(artifactId)) {
                this.getLog().info((CharSequence)("Skipping excluded artifact: " + artifact.toString()));
                continue;
            }
            File file = artifact.getFile();
            File dest = new File(repoDirectory, layout.pathOf(artifact));
            this.getLog().debug((CharSequence)("Adding " + file));
            try {
                FileUtils.copyFile((File)file, (File)dest);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file " + file + " into " + javaDirectory, (Exception)e);
            }
            list.add(repoDirectory.getName() + "/" + layout.pathOf(artifact));
        }
        return list;
    }

    private void writeInfoPlist(File infoPlist, List files) throws MojoExecutionException {
        int i;
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("mainClass", (Object)this.mainClass);
        velocityContext.put("cfBundleExecutable", (Object)this.javaApplicationStub.getName());
        velocityContext.put("vmOptions", (Object)this.vmOptions);
        velocityContext.put("bundleName", (Object)this.cleanBundleName(this.bundleName));
        velocityContext.put("iconFile", (Object)(this.iconFile == null ? "GenericJavaApp.icns" : this.iconFile.getName()));
        velocityContext.put("version", (Object)this.version);
        velocityContext.put("jvmVersion", (Object)this.jvmVersion);
        this.addMavenPropertiesToVelocity(velocityContext);
        StringBuffer jarFilesBuffer = new StringBuffer();
        jarFilesBuffer.append("<array>");
        for (i = 0; i < files.size(); ++i) {
            String name = (String)files.get(i);
            jarFilesBuffer.append("<string>");
            jarFilesBuffer.append("$JAVAROOT/").append(name);
            jarFilesBuffer.append("</string>");
        }
        if (this.additionalClasspath != null) {
            for (i = 0; i < this.additionalClasspath.size(); ++i) {
                String pathElement = (String)this.additionalClasspath.get(i);
                jarFilesBuffer.append("<string>");
                jarFilesBuffer.append(pathElement);
                jarFilesBuffer.append("</string>");
            }
        }
        jarFilesBuffer.append("</array>");
        velocityContext.put("classpath", (Object)jarFilesBuffer.toString());
        try {
            String encoding = this.detectEncoding(this.dictionaryFile, velocityContext);
            this.getLog().debug((CharSequence)("Detected encoding " + encoding + " for dictionary file " + this.dictionaryFile));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(infoPlist), encoding);
            this.velocity.getEngine().mergeTemplate(this.dictionaryFile, encoding, (Context)velocityContext, (Writer)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write Info.plist to file " + infoPlist, (Exception)e);
        }
        catch (ParseErrorException e) {
            throw new MojoExecutionException("Error parsing " + this.dictionaryFile, (Exception)((Object)e));
        }
        catch (ResourceNotFoundException e) {
            throw new MojoExecutionException("Could not find resource for template " + this.dictionaryFile, (Exception)((Object)e));
        }
        catch (MethodInvocationException e) {
            throw new MojoExecutionException("MethodInvocationException occured merging Info.plist template " + this.dictionaryFile, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception occured merging Info.plist template " + this.dictionaryFile, e);
        }
    }

    private void addMavenPropertiesToVelocity(VelocityContext velocityContext) {
        Properties mavenProps = this.project.getProperties();
        Iterator<Map.Entry<Object, Object>> propertyIterator = mavenProps.entrySet().iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry<Object, Object> propertyEntry = propertyIterator.next();
            String key = (String)propertyEntry.getKey();
            String value = (String)propertyEntry.getValue();
            if (key.indexOf("password") >= 0 || key.indexOf("passphrase") >= 0) continue;
            velocityContext.put("maven." + key, (Object)value);
        }
    }

    private String detectEncoding(String dictionaryFile, VelocityContext velocityContext) throws Exception {
        StringWriter sw = new StringWriter();
        this.velocity.getEngine().mergeTemplate(dictionaryFile, "utf-8", (Context)velocityContext, (Writer)sw);
        return new DefaultEncodingDetector().detectXmlEncoding(new ByteArrayInputStream(sw.toString().getBytes("utf-8")));
    }

    private void copyResources(List fileSets) throws MojoExecutionException {
        String[] emptyStrArray = new String[]{};
        Iterator it = fileSets.iterator();
        while (it.hasNext()) {
            FileSet fileSet = (FileSet)((Object)it.next());
            File resourceDirectory = new File(fileSet.getDirectory());
            if (!resourceDirectory.isAbsolute()) {
                resourceDirectory = new File(this.project.getBasedir(), resourceDirectory.getPath());
            }
            if (!resourceDirectory.exists()) {
                this.getLog().info((CharSequence)("Additional resource directory does not exist: " + resourceDirectory));
                continue;
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(resourceDirectory);
            if (fileSet.getIncludes() != null && !fileSet.getIncludes().isEmpty()) {
                scanner.setIncludes(fileSet.getIncludes().toArray(emptyStrArray));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES);
            }
            if (fileSet.getExcludes() != null && !fileSet.getExcludes().isEmpty()) {
                scanner.setExcludes(fileSet.getExcludes().toArray(emptyStrArray));
            }
            if (fileSet.isUseDefaultExcludes()) {
                scanner.addDefaultExcludes();
            }
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            this.getLog().info((CharSequence)("Copying " + includedFiles.size() + " additional resource" + (includedFiles.size() > 1 ? "s" : "")));
            Iterator<String> j = includedFiles.iterator();
            while (j.hasNext()) {
                String destination = j.next();
                File source = new File(resourceDirectory, destination);
                File destinationFile = new File(this.buildDirectory, destination);
                if (!destinationFile.getParentFile().exists()) {
                    destinationFile.getParentFile().mkdirs();
                }
                try {
                    FileUtils.copyFile((File)source, (File)destinationFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error copying additional resource " + source, (Exception)e);
                }
            }
        }
    }

    private void createDMG() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Building DMG: " + this.diskImageFile.getAbsolutePath()));
        Commandline dmg = new Commandline();
        boolean needsRemount = this.volumeIconFile != null && this.volumeIconFile.exists();
        File targetFile = this.diskImageFile;
        if (needsRemount) {
            try {
                targetFile = File.createTempFile("image", ".dmg", this.diskImageFile.getParentFile());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to create image file: " + e.getMessage()), (Throwable)e);
            }
        }
        try {
            dmg.setExecutable("hdiutil");
            dmg.createArgument().setValue("create");
            dmg.createArgument().setValue("-format");
            dmg.createArgument().setValue(needsRemount ? "UDRW" : "UDZO");
            dmg.createArgument().setValue("-fs");
            dmg.createArgument().setValue("HFS+");
            dmg.createArgument().setValue("-volname");
            dmg.createArgument().setValue(this.volumeLabel != null ? this.volumeLabel : this.bundleName);
            dmg.createArgument().setValue("-srcfolder");
            dmg.createArgument().setFile(this.buildDirectory);
            dmg.createArgument().setValue("-ov");
            dmg.createArgument().setFile(targetFile);
            dmg.execute().waitFor();
            if (needsRemount) {
                dmg.clearArgs();
                dmg.createArgument().setValue("attach");
                dmg.createArgument().setFile(targetFile);
                dmg.createArgument().setValue("-mountpoint");
                dmg.createArgument().setFile(this.buildDirectory);
                dmg.execute().waitFor();
                this.setFileAttributes(this.buildDirectory, "C");
                dmg.clearArgs();
                dmg.createArgument().setValue("detach");
                dmg.createArgument().setFile(this.buildDirectory);
                dmg.execute().waitFor();
                dmg.clearArgs();
                dmg.createArgument().setValue("convert");
                dmg.createArgument().setFile(targetFile);
                dmg.createArgument().setValue("-format");
                dmg.createArgument().setValue("UDZO");
                dmg.createArgument().setValue("-o");
                dmg.createArgument().setFile(this.diskImageFile);
                dmg.execute().waitFor();
                targetFile.delete();
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error creating disk image " + this.diskImageFile, (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Thread was interrupted while creating DMG " + this.diskImageFile, (Exception)e);
        }
        if (this.internetEnable) {
            try {
                Commandline internetEnable = new Commandline();
                internetEnable.setExecutable("hdiutil");
                internetEnable.createArgument().setValue("internet-enable");
                internetEnable.createArgument().setValue("-yes");
                internetEnable.createArgument().setValue(this.diskImageFile.getAbsolutePath());
                internetEnable.execute();
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Error internet enabling disk image: " + this.diskImageFile, (Exception)((Object)e));
            }
        }
        this.projectHelper.attachArtifact(this.project, "dmg", null, this.diskImageFile);
    }

    private void createZip() throws MojoExecutionException {
        this.zipArchiver.setDestFile(this.zipFile);
        try {
            String[] stubPattern = new String[]{this.buildDirectory.getName() + "/" + this.cleanBundleName(this.bundleName) + ".app/Contents/MacOS/" + this.javaApplicationStub.getName()};
            this.zipArchiver.addDirectory(this.buildDirectory.getParentFile(), new String[]{this.buildDirectory.getName() + "/**"}, stubPattern);
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.buildDirectory.getParentFile());
            scanner.setIncludes(stubPattern);
            scanner.scan();
            String[] stubs = scanner.getIncludedFiles();
            for (int i = 0; i < stubs.length; ++i) {
                String s = stubs[i];
                this.zipArchiver.addFile(new File(this.buildDirectory.getParentFile(), s), s, 493);
            }
            this.zipArchiver.createArchive();
            this.projectHelper.attachArtifact(this.project, "zip", null, this.zipFile);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Could not create zip archive of application bundle in " + this.zipFile, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException creating zip archive of application bundle in " + this.zipFile, (Exception)e);
        }
    }

    private void setFileAttributes(File file, String attributes) {
        if (this.setFilePath != null) {
            Commandline setFile = new Commandline();
            try {
                setFile.setExecutable(this.setFilePath);
                setFile.createArgument().setValue("-a");
                setFile.createArgument().setValue(attributes);
                setFile.createArgument().setFile(file);
                setFile.execute();
            }
            catch (CommandLineException e) {
                this.getLog().warn((CharSequence)("Error executing " + setFile), (Throwable)e);
            }
        } else {
            this.getLog().warn((CharSequence)"Could  not set special file attributes. SetFile not found, is Xcode installed?");
        }
    }
}

