/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.store;

import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.store.EventBasedRecordWriter.FieldConverter;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

import java.io.IOException;
import java.lang.UnsupportedOperationException;
import java.util.Map;

/** RecordWriter interface. */
public interface RecordWriter {

  /**
   * Initialize the writer.
   *
   * @param writerOptions Contains key, value pair of settings.
   * @throws IOException
   */
  void init(Map<String, String> writerOptions) throws IOException;

  /**
   * Update the schema in RecordWriter. Called at least once before starting writing the records.
   * @param schema
   * @throws IOException
   */
  void updateSchema(BatchSchema schema) throws IOException;

  /**
   * Called before starting writing fields in a record.
   * @throws IOException
   */
  void startRecord() throws IOException;

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewMapConverter(int fieldId, String fieldName, FieldReader reader);
  public FieldConverter getNewRepeatedMapConverter(int fieldId, String fieldName, FieldReader reader);
  public FieldConverter getNewRepeatedListConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableTinyIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewTinyIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedTinyIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableUInt1Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewUInt1Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedUInt1Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableUInt2Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewUInt2Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedUInt2Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableSmallIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewSmallIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedSmallIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableUInt4Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewUInt4Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedUInt4Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableFloat4Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewFloat4Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedFloat4Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableTimeConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewTimeConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedTimeConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableIntervalYearConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewIntervalYearConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedIntervalYearConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableDecimal9Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewDecimal9Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedDecimal9Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableBigIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewBigIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedBigIntConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableUInt8Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewUInt8Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedUInt8Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableFloat8Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewFloat8Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedFloat8Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableDateConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewDateConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedDateConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableTimeStampConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewTimeStampConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedTimeStampConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableDecimal18Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewDecimal18Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedDecimal18Converter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableTimeStampTZConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewTimeStampTZConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedTimeStampTZConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableIntervalDayConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewIntervalDayConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedIntervalDayConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableIntervalConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewIntervalConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedIntervalConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableVarBinaryConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewVarBinaryConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedVarBinaryConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableVarCharConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewVarCharConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedVarCharConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableVar16CharConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewVar16CharConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedVar16CharConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewNullableBitConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewBitConverter(int fieldId, String fieldName, FieldReader reader);

  /** Add the field value given in <code>valueHolder</code> at the given column number <code>fieldId</code>. */
  public FieldConverter getNewRepeatedBitConverter(int fieldId, String fieldName, FieldReader reader);


  /**
   * Called after adding all fields in a particular record are added using add{TypeHolder}(fieldId, TypeHolder) methods.
   * @throws IOException
   */
  void endRecord() throws IOException;

  void abort() throws IOException;
  void cleanup() throws IOException;
}
