
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

@SuppressWarnings("unused")
@FunctionTemplate(name = "castINT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
public class CastVarBinaryInt implements DrillSimpleFunc{

  @Param VarBinaryHolder in;
  @Output IntHolder out;

  public void setup(RecordBatch incoming) {}

  public void eval() {

      if ((in.end - in.start) ==0) {
        //empty, not a valid number
        byte[] buf = new byte[in.end - in.start];
        in.buffer.getBytes(in.start, buf, 0, in.end - in.start);  
        throw new NumberFormatException(new String(buf, com.google.common.base.Charsets.UTF_8));  
      }

      int readIndex = in.start;

      boolean negative = in.buffer.getByte(readIndex) == '-';
      
      if (negative && ++readIndex == in.end) {
        //only one single '-'
        byte[] buf = new byte[in.end - in.start];
        in.buffer.getBytes(in.start, buf, 0, in.end - in.start);  
        throw new NumberFormatException(new String(buf, com.google.common.base.Charsets.UTF_8));  
      }
   
      int radix = 10;
      int max = -Integer.MAX_VALUE / radix;
      int result = 0;
      int digit;
      
      while (readIndex < in.end) {
        digit = Character.digit(in.buffer.getByte(readIndex++),radix);
        //not valid digit.
        if (digit == -1) {
          byte[] buf = new byte[in.end - in.start];
          in.buffer.getBytes(in.start, buf, 0, in.end - in.start);  
          throw new NumberFormatException(new String(buf, com.google.common.base.Charsets.UTF_8));  
        }
        //overflow
        if (max > result) {
          byte[] buf = new byte[in.end - in.start];
          in.buffer.getBytes(in.start, buf, 0, in.end - in.start);  
          throw new NumberFormatException(new String(buf, com.google.common.base.Charsets.UTF_8));  
        }
        
        int next = result * radix - digit;
        
        //overflow
        if (next > result) {
          byte[] buf = new byte[in.end - in.start];
          in.buffer.getBytes(in.start, buf, 0, in.end - in.start);  
          throw new NumberFormatException(new String(buf, com.google.common.base.Charsets.UTF_8));  
        }
        result = next;
      }
      if (!negative) {
        result = -result;
        //overflow
        if (result < 0) {
          byte[] buf = new byte[in.end - in.start];
          in.buffer.getBytes(in.start, buf, 0, in.end - in.start);  
          throw new NumberFormatException(new String(buf, com.google.common.base.Charsets.UTF_8));  
        }
      }
   
      out.value = result;
    
  }
}

 

