
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

/*
 * This class is automatically generated from AggrTypeFunctions1.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

@SuppressWarnings("unused")

public class MaxDateTypeFunctions {

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class DateMax implements DrillAggFunc{

  @Param DateHolder in;
  @Workspace DateHolder value;
  @Output DateHolder out;

  public void setup(RecordBatch b) {
	value = new DateHolder();
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {

    value.value = Math.max(value.value, in.value);

  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableDateMax implements DrillAggFunc{

  @Param NullableDateHolder in;
  @Workspace DateHolder value;
  @Output DateHolder out;

  public void setup(RecordBatch b) {
	value = new DateHolder();
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

    value.value = Math.max(value.value, in.value);

    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class TimeStampMax implements DrillAggFunc{

  @Param TimeStampHolder in;
  @Workspace TimeStampHolder value;
  @Output TimeStampHolder out;

  public void setup(RecordBatch b) {
	value = new TimeStampHolder();
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {

    value.value = Math.max(value.value, in.value);

  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableTimeStampMax implements DrillAggFunc{

  @Param NullableTimeStampHolder in;
  @Workspace TimeStampHolder value;
  @Output TimeStampHolder out;

  public void setup(RecordBatch b) {
	value = new TimeStampHolder();
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

    value.value = Math.max(value.value, in.value);

    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class TimeStampTZMax implements DrillAggFunc{

  @Param TimeStampTZHolder in;
  @Workspace TimeStampTZHolder value;
  @Output TimeStampTZHolder out;

  public void setup(RecordBatch b) {
	value = new TimeStampTZHolder();
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {

    if (in.value < value.value) {
      value.value = in.value;
      value.index = in.index;
    }

  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableTimeStampTZMax implements DrillAggFunc{

  @Param NullableTimeStampTZHolder in;
  @Workspace TimeStampTZHolder value;
  @Output TimeStampTZHolder out;

  public void setup(RecordBatch b) {
	value = new TimeStampTZHolder();
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

    if (in.value < value.value) {
      value.value = in.value;
      value.index = in.index;
    }

    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class TimeMax implements DrillAggFunc{

  @Param TimeHolder in;
  @Workspace TimeHolder value;
  @Output TimeHolder out;

  public void setup(RecordBatch b) {
	value = new TimeHolder();
    value.value = Integer.MIN_VALUE;
  }

  @Override
  public void add() {

    value.value = Math.max(value.value, in.value);

  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = Integer.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableTimeMax implements DrillAggFunc{

  @Param NullableTimeHolder in;
  @Workspace TimeHolder value;
  @Output TimeHolder out;

  public void setup(RecordBatch b) {
	value = new TimeHolder();
    value.value = Integer.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

    value.value = Math.max(value.value, in.value);

    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = Integer.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalDayMax implements DrillAggFunc{

  @Param IntervalDayHolder in;
  @Workspace BigIntHolder value;
  @Output IntervalDayHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {

    long inMS = (long) in.days * (org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis) +
                       in.milliseconds;

    value.value = Math.max(value.value, inMS);

  }

  @Override
  public void output() {

    out.days = (int) (value.value / org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
    out.milliseconds = (int) (value.value % org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
  }

  @Override
  public void reset() {
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalDayMax implements DrillAggFunc{

  @Param NullableIntervalDayHolder in;
  @Workspace BigIntHolder value;
  @Output IntervalDayHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

    long inMS = (long) in.days * (org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis) +
                       in.milliseconds;

    value.value = Math.max(value.value, inMS);

    } // end of sout block
  }

  @Override
  public void output() {

    out.days = (int) (value.value / org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
    out.milliseconds = (int) (value.value % org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
  }

  @Override
  public void reset() {
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalYearMax implements DrillAggFunc{

  @Param IntervalYearHolder in;
  @Workspace IntervalYearHolder value;
  @Output IntervalYearHolder out;

  public void setup(RecordBatch b) {
	value = new IntervalYearHolder();
    value.value = Integer.MIN_VALUE;
  }

  @Override
  public void add() {

    value.value = Math.max(value.value, in.value);

  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = Integer.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalYearMax implements DrillAggFunc{

  @Param NullableIntervalYearHolder in;
  @Workspace IntervalYearHolder value;
  @Output IntervalYearHolder out;

  public void setup(RecordBatch b) {
	value = new IntervalYearHolder();
    value.value = Integer.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

    value.value = Math.max(value.value, in.value);

    } // end of sout block
  }

  @Override
  public void output() {

    out.value = value.value;
  }

  @Override
  public void reset() {
    value.value = Integer.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntervalMax implements DrillAggFunc{

  @Param IntervalHolder in;
  @Workspace BigIntHolder value;
  @Output IntervalHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {

    long inMS = (long) in.months * org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis+
                       in.days * (org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis) +
                       in.milliseconds;

    value.value = Math.max(value.value, inMS);

  }

  @Override
  public void output() {

    out.months = (int) (value.value / org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis);
    value.value = value.value % org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis;
    out.days = (int) (value.value / org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
    out.milliseconds = (int) (value.value % org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
  }

  @Override
  public void reset() {
    value.value = Long.MIN_VALUE;
  }

 }

@FunctionTemplate(name = "max", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntervalMax implements DrillAggFunc{

  @Param NullableIntervalHolder in;
  @Workspace BigIntHolder value;
  @Output IntervalHolder out;

  public void setup(RecordBatch b) {
	value = new BigIntHolder();
    value.value = Long.MIN_VALUE;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }

    long inMS = (long) in.months * org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis+
                       in.days * (org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis) +
                       in.milliseconds;

    value.value = Math.max(value.value, inMS);

    } // end of sout block
  }

  @Override
  public void output() {

    out.months = (int) (value.value / org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis);
    value.value = value.value % org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis;
    out.days = (int) (value.value / org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
    out.milliseconds = (int) (value.value % org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
  }

  @Override
  public void reset() {
    value.value = Long.MIN_VALUE;
  }

 }

}
