
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

/*
 * This class is automatically generated from AggrBitwiseLogicalTypes.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.record.RecordBatch;

@SuppressWarnings("unused")

public class BitwiseOrFunctions {
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(BitwiseOrFunctions.class);


@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class BigIntBitwiseOr implements DrillAggFunc{

  @Param BigIntHolder in;
  @Workspace BigIntHolder inter;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
  inter = new BigIntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {

    inter.value = (inter.value | in.value);

  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableBigIntBitwiseOr implements DrillAggFunc{

  @Param NullableBigIntHolder in;
  @Workspace BigIntHolder inter;
  @Output BigIntHolder out;

  public void setup(RecordBatch b) {
  inter = new BigIntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {
    sout: {
    if (in.isSet == 0) {
     // processing nullable input and the value is null, so don't do anything...
     break sout;
    }

    inter.value = (inter.value | in.value);

    } // end of sout block
  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class IntBitwiseOr implements DrillAggFunc{

  @Param IntHolder in;
  @Workspace IntHolder inter;
  @Output IntHolder out;

  public void setup(RecordBatch b) {
  inter = new IntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {

    inter.value = (inter.value | in.value);

  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableIntBitwiseOr implements DrillAggFunc{

  @Param NullableIntHolder in;
  @Workspace IntHolder inter;
  @Output IntHolder out;

  public void setup(RecordBatch b) {
  inter = new IntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {
    sout: {
    if (in.isSet == 0) {
     // processing nullable input and the value is null, so don't do anything...
     break sout;
    }

    inter.value = (inter.value | in.value);

    } // end of sout block
  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class SmallIntBitwiseOr implements DrillAggFunc{

  @Param SmallIntHolder in;
  @Workspace SmallIntHolder inter;
  @Output SmallIntHolder out;

  public void setup(RecordBatch b) {
  inter = new SmallIntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {

    inter.value = (short)(inter.value | in.value);

  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableSmallIntBitwiseOr implements DrillAggFunc{

  @Param NullableSmallIntHolder in;
  @Workspace SmallIntHolder inter;
  @Output SmallIntHolder out;

  public void setup(RecordBatch b) {
  inter = new SmallIntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {
    sout: {
    if (in.isSet == 0) {
     // processing nullable input and the value is null, so don't do anything...
     break sout;
    }

    inter.value = (short)(inter.value | in.value);

    } // end of sout block
  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class TinyIntBitwiseOr implements DrillAggFunc{

  @Param TinyIntHolder in;
  @Workspace TinyIntHolder inter;
  @Output TinyIntHolder out;

  public void setup(RecordBatch b) {
  inter = new TinyIntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {

    inter.value = (byte)(inter.value | in.value);

  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableTinyIntBitwiseOr implements DrillAggFunc{

  @Param NullableTinyIntHolder in;
  @Workspace TinyIntHolder inter;
  @Output TinyIntHolder out;

  public void setup(RecordBatch b) {
  inter = new TinyIntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {
    sout: {
    if (in.isSet == 0) {
     // processing nullable input and the value is null, so don't do anything...
     break sout;
    }

    inter.value = (byte)(inter.value | in.value);

    } // end of sout block
  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class UInt1BitwiseOr implements DrillAggFunc{

  @Param UInt1Holder in;
  @Workspace IntHolder inter;
  @Output IntHolder out;

  public void setup(RecordBatch b) {
  inter = new IntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {

    inter.value = (inter.value | in.value);

  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableUInt1BitwiseOr implements DrillAggFunc{

  @Param NullableUInt1Holder in;
  @Workspace IntHolder inter;
  @Output IntHolder out;

  public void setup(RecordBatch b) {
  inter = new IntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {
    sout: {
    if (in.isSet == 0) {
     // processing nullable input and the value is null, so don't do anything...
     break sout;
    }

    inter.value = (inter.value | in.value);

    } // end of sout block
  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class UInt2BitwiseOr implements DrillAggFunc{

  @Param UInt2Holder in;
  @Workspace IntHolder inter;
  @Output IntHolder out;

  public void setup(RecordBatch b) {
  inter = new IntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {

    inter.value = (inter.value | in.value);

  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableUInt2BitwiseOr implements DrillAggFunc{

  @Param NullableUInt2Holder in;
  @Workspace IntHolder inter;
  @Output IntHolder out;

  public void setup(RecordBatch b) {
  inter = new IntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {
    sout: {
    if (in.isSet == 0) {
     // processing nullable input and the value is null, so don't do anything...
     break sout;
    }

    inter.value = (inter.value | in.value);

    } // end of sout block
  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class UInt4BitwiseOr implements DrillAggFunc{

  @Param UInt4Holder in;
  @Workspace IntHolder inter;
  @Output IntHolder out;

  public void setup(RecordBatch b) {
  inter = new IntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {

    inter.value = (inter.value | in.value);

  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableUInt4BitwiseOr implements DrillAggFunc{

  @Param NullableUInt4Holder in;
  @Workspace IntHolder inter;
  @Output IntHolder out;

  public void setup(RecordBatch b) {
  inter = new IntHolder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {
    sout: {
    if (in.isSet == 0) {
     // processing nullable input and the value is null, so don't do anything...
     break sout;
    }

    inter.value = (inter.value | in.value);

    } // end of sout block
  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class UInt8BitwiseOr implements DrillAggFunc{

  @Param UInt8Holder in;
  @Workspace UInt8Holder inter;
  @Output UInt8Holder out;

  public void setup(RecordBatch b) {
  inter = new UInt8Holder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {

    inter.value = (inter.value | in.value);

  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}



@FunctionTemplate(name = "bit_or", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
public static class NullableUInt8BitwiseOr implements DrillAggFunc{

  @Param NullableUInt8Holder in;
  @Workspace UInt8Holder inter;
  @Output UInt8Holder out;

  public void setup(RecordBatch b) {
  inter = new UInt8Holder();

    // Initialize the workspace variables
    inter.value = 0;
  }

  @Override
  public void add() {
    sout: {
    if (in.isSet == 0) {
     // processing nullable input and the value is null, so don't do anything...
     break sout;
    }

    inter.value = (inter.value | in.value);

    } // end of sout block
  }

  @Override
  public void output() {
      out.value = inter.value;
  }

  @Override
  public void reset() {
      inter.value = 0;
  }
}


}
