
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.joda.time.MutableDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DateMidnight;
import org.apache.drill.exec.expr.fn.impl.DateUtility;


public class IntervalDayFloat4Functions {


    @SuppressWarnings("unused")
    @FunctionTemplate(name = "multiply", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class IntervalDayFloat4MultiplyFunction implements DrillSimpleFunc {
    @Param IntervalDayHolder left;
    @Param Float4Holder right;
    @Output IntervalHolder out;

        public void setup(RecordBatch incoming) {
        }

        public void eval() {
    double fractionalMonths = 0;
    double fractionalDays = 0;
    double fractionalMillis = 0;

    fractionalDays = (left.days * right.value);
    fractionalMillis = (left.milliseconds * (double) right.value);

    out.months = (int) fractionalMonths;

    // Transfer fractional part to days
    fractionalMonths = fractionalMonths - (long) fractionalMonths;
    fractionalDays += fractionalMonths * org.apache.drill.exec.expr.fn.impl.DateUtility.monthToStandardDays;
    out.days = (int) fractionalDays;

    // Transfer fractional part to millis
    fractionalDays = fractionalDays - (long) fractionalDays;
    fractionalMillis += fractionalDays * org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis;

    out.milliseconds = (int) fractionalMillis;
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(name = "multiply", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class Float4IntervalDayMultiplyFunction implements DrillSimpleFunc {
    @Param Float4Holder right;
    @Param IntervalDayHolder left;
    @Output IntervalHolder out;

        public void setup(RecordBatch incoming) {
        }

        public void eval() {
    double fractionalMonths = 0;
    double fractionalDays = 0;
    double fractionalMillis = 0;

    fractionalDays = (left.days * right.value);
    fractionalMillis = (left.milliseconds * (double) right.value);

    out.months = (int) fractionalMonths;

    // Transfer fractional part to days
    fractionalMonths = fractionalMonths - (long) fractionalMonths;
    fractionalDays += fractionalMonths * org.apache.drill.exec.expr.fn.impl.DateUtility.monthToStandardDays;
    out.days = (int) fractionalDays;

    // Transfer fractional part to millis
    fractionalDays = fractionalDays - (long) fractionalDays;
    fractionalMillis += fractionalDays * org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis;

    out.milliseconds = (int) fractionalMillis;
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"divide", "div"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class IntervalDayFloat4DivideFunction implements DrillSimpleFunc {
    @Param IntervalDayHolder left;
    @Param Float4Holder right;
    @Output IntervalHolder out;

        public void setup(RecordBatch incoming) {
        }

        public void eval() {
    double fractionalMonths = 0;
    double fractionalDays = 0;
    double fractionalMillis = 0;

    fractionalDays = (left.days / right.value);
    fractionalMillis = (left.milliseconds / (double) right.value);

    out.months = (int) fractionalMonths;

    // Transfer fractional part to days
    fractionalMonths = fractionalMonths - (long) fractionalMonths;
    fractionalDays += fractionalMonths * org.apache.drill.exec.expr.fn.impl.DateUtility.monthToStandardDays;
    out.days = (int) fractionalDays;

    // Transfer fractional part to millis
    fractionalDays = fractionalDays - (long) fractionalDays;
    fractionalMillis += fractionalDays * org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis;

    out.milliseconds = (int) fractionalMillis;
        }
    }
}

