/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
//////////////////////////////////////////////////////////////////////////////////////////////////
//Functions for Extended Math Functions
//////////////////////////////////////////////////////////////////////////////////////////////////


package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.types.TypeProtos.MinorType;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.fn.impl.StringFunctions;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import java.math.BigDecimal;
/*
 * This class is automatically generated from MathFunc.tdd using FreeMarker.
 */

@SuppressWarnings("unused")

public class ExtendedMathFunctions{
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(ExtendedMathFunctions.class);

  private ExtendedMathFunctions(){}

//////////////////////////////////////////////////////////////////////////////////////////////////
//Unary Math functions with 1 parameter.
//////////////////////////////////////////////////////////////////////////////////////////////////



@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtInt implements DrillSimpleFunc {

  @Param IntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.cbrt(in.value);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtBigInt implements DrillSimpleFunc {

  @Param BigIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.cbrt(in.value);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtFloat4 implements DrillSimpleFunc {

  @Param Float4Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.cbrt(in.value);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtFloat8 implements DrillSimpleFunc {

  @Param Float8Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.cbrt(in.value);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtSmallInt implements DrillSimpleFunc {

  @Param SmallIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.cbrt(in.value);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtTinyInt implements DrillSimpleFunc {

  @Param TinyIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.cbrt(in.value);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtUInt1 implements DrillSimpleFunc {

  @Param UInt1Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.cbrt(in.value);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtUInt2 implements DrillSimpleFunc {

  @Param UInt2Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.cbrt(in.value);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtUInt4 implements DrillSimpleFunc {

  @Param UInt4Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.cbrt(in.value);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtUInt8 implements DrillSimpleFunc {

  @Param UInt8Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.cbrt(in.value);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtDecimal9 implements DrillSimpleFunc {

  @Param Decimal9Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(in.value).setScale(in.scale).doubleValue();
	  out.value = java.lang.Math.cbrt(dblval);
  }
}


@FunctionTemplate(name = "cbrt", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class CbrtDecimal18 implements DrillSimpleFunc {

  @Param Decimal18Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(in.value).setScale(in.scale).doubleValue();
	  out.value = java.lang.Math.cbrt(dblval);
  }
}



@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpInt implements DrillSimpleFunc {

  @Param IntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.exp(in.value);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpBigInt implements DrillSimpleFunc {

  @Param BigIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.exp(in.value);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpFloat4 implements DrillSimpleFunc {

  @Param Float4Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.exp(in.value);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpFloat8 implements DrillSimpleFunc {

  @Param Float8Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.exp(in.value);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpSmallInt implements DrillSimpleFunc {

  @Param SmallIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.exp(in.value);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpTinyInt implements DrillSimpleFunc {

  @Param TinyIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.exp(in.value);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpUInt1 implements DrillSimpleFunc {

  @Param UInt1Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.exp(in.value);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpUInt2 implements DrillSimpleFunc {

  @Param UInt2Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.exp(in.value);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpUInt4 implements DrillSimpleFunc {

  @Param UInt4Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.exp(in.value);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpUInt8 implements DrillSimpleFunc {

  @Param UInt8Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.exp(in.value);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpDecimal9 implements DrillSimpleFunc {

  @Param Decimal9Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(in.value).setScale(in.scale).doubleValue();
	  out.value = java.lang.Math.exp(dblval);
  }
}


@FunctionTemplate(name = "exp", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class ExpDecimal18 implements DrillSimpleFunc {

  @Param Decimal18Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(in.value).setScale(in.scale).doubleValue();
	  out.value = java.lang.Math.exp(dblval);
  }
}



@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogInt implements DrillSimpleFunc {

  @Param IntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(in.value);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBigInt implements DrillSimpleFunc {

  @Param BigIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(in.value);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogFloat4 implements DrillSimpleFunc {

  @Param Float4Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(in.value);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogFloat8 implements DrillSimpleFunc {

  @Param Float8Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(in.value);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogSmallInt implements DrillSimpleFunc {

  @Param SmallIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(in.value);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogTinyInt implements DrillSimpleFunc {

  @Param TinyIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(in.value);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogUInt1 implements DrillSimpleFunc {

  @Param UInt1Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(in.value);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogUInt2 implements DrillSimpleFunc {

  @Param UInt2Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(in.value);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogUInt4 implements DrillSimpleFunc {

  @Param UInt4Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(in.value);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogUInt8 implements DrillSimpleFunc {

  @Param UInt8Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(in.value);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogDecimal9 implements DrillSimpleFunc {

  @Param Decimal9Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(in.value).setScale(in.scale).doubleValue();
	  out.value = java.lang.Math.log(dblval);
  }
}


@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogDecimal18 implements DrillSimpleFunc {

  @Param Decimal18Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(in.value).setScale(in.scale).doubleValue();
	  out.value = java.lang.Math.log(dblval);
  }
}



@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesInt implements DrillSimpleFunc {

  @Param IntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toDegrees(in.value);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesBigInt implements DrillSimpleFunc {

  @Param BigIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toDegrees(in.value);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesFloat4 implements DrillSimpleFunc {

  @Param Float4Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toDegrees(in.value);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesFloat8 implements DrillSimpleFunc {

  @Param Float8Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toDegrees(in.value);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesSmallInt implements DrillSimpleFunc {

  @Param SmallIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toDegrees(in.value);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesTinyInt implements DrillSimpleFunc {

  @Param TinyIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toDegrees(in.value);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesUInt1 implements DrillSimpleFunc {

  @Param UInt1Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toDegrees(in.value);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesUInt2 implements DrillSimpleFunc {

  @Param UInt2Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toDegrees(in.value);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesUInt4 implements DrillSimpleFunc {

  @Param UInt4Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toDegrees(in.value);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesUInt8 implements DrillSimpleFunc {

  @Param UInt8Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toDegrees(in.value);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesDecimal9 implements DrillSimpleFunc {

  @Param Decimal9Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(in.value).setScale(in.scale).doubleValue();
	  out.value = java.lang.Math.toDegrees(dblval);
  }
}


@FunctionTemplate(name = "degrees", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class DegreesDecimal18 implements DrillSimpleFunc {

  @Param Decimal18Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(in.value).setScale(in.scale).doubleValue();
	  out.value = java.lang.Math.toDegrees(dblval);
  }
}



@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansInt implements DrillSimpleFunc {

  @Param IntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toRadians(in.value);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansBigInt implements DrillSimpleFunc {

  @Param BigIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toRadians(in.value);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansFloat4 implements DrillSimpleFunc {

  @Param Float4Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toRadians(in.value);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansFloat8 implements DrillSimpleFunc {

  @Param Float8Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toRadians(in.value);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansSmallInt implements DrillSimpleFunc {

  @Param SmallIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toRadians(in.value);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansTinyInt implements DrillSimpleFunc {

  @Param TinyIntHolder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toRadians(in.value);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansUInt1 implements DrillSimpleFunc {

  @Param UInt1Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toRadians(in.value);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansUInt2 implements DrillSimpleFunc {

  @Param UInt2Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toRadians(in.value);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansUInt4 implements DrillSimpleFunc {

  @Param UInt4Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toRadians(in.value);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansUInt8 implements DrillSimpleFunc {

  @Param UInt8Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.toRadians(in.value);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansDecimal9 implements DrillSimpleFunc {

  @Param Decimal9Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(in.value).setScale(in.scale).doubleValue();
	  out.value = java.lang.Math.toRadians(dblval);
  }
}


@FunctionTemplate(name = "radians", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class RadiansDecimal18 implements DrillSimpleFunc {

  @Param Decimal18Holder in;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(in.value).setScale(in.scale).doubleValue();
	  out.value = java.lang.Math.toRadians(dblval);
  }
}



//////////////////////////////////////////////////////////////////////////////////////////////////
//Function to handle Log with base.
//////////////////////////////////////////////////////////////////////////////////////////////////

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseInt implements DrillSimpleFunc {

  @Param IntHolder base;
  @Param IntHolder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(val.value)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseBigInt implements DrillSimpleFunc {

  @Param BigIntHolder base;
  @Param BigIntHolder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(val.value)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseFloat4 implements DrillSimpleFunc {

  @Param Float4Holder base;
  @Param Float4Holder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(val.value)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseFloat8 implements DrillSimpleFunc {

  @Param Float8Holder base;
  @Param Float8Holder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(val.value)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseSmallInt implements DrillSimpleFunc {

  @Param SmallIntHolder base;
  @Param SmallIntHolder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(val.value)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseTinyInt implements DrillSimpleFunc {

  @Param TinyIntHolder base;
  @Param TinyIntHolder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(val.value)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseUInt1 implements DrillSimpleFunc {

  @Param UInt1Holder base;
  @Param UInt1Holder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(val.value)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseUInt2 implements DrillSimpleFunc {

  @Param UInt2Holder base;
  @Param UInt2Holder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(val.value)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseUInt4 implements DrillSimpleFunc {

  @Param UInt4Holder base;
  @Param UInt4Holder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(val.value)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseUInt8 implements DrillSimpleFunc {

  @Param UInt8Holder base;
  @Param UInt8Holder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  out.value = java.lang.Math.log(val.value)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseDecimal9 implements DrillSimpleFunc {

  @Param Decimal9Holder base;
  @Param Decimal9Holder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(val.value).setScale(val.scale).doubleValue();
	  out.value = java.lang.Math.log(dblval)/ java.lang.Math.log(base.value);
  }
}

@FunctionTemplate(name = "log", scope = FunctionScope.SIMPLE, nulls = NullHandling.NULL_IF_NULL)
public static class LogBaseDecimal18 implements DrillSimpleFunc {

  @Param Decimal18Holder base;
  @Param Decimal18Holder val;
  @Output Float8Holder out;

  public void setup(RecordBatch b) {
  }

  public void eval() {
	  double dblval = new BigDecimal(val.value).setScale(val.scale).doubleValue();
	  out.value = java.lang.Math.log(dblval)/ java.lang.Math.log(base.value);
  }
}


}

//////////////////////////////////////////////////////////////////////////////////////////////////
//End of Extended Math Functions
//////////////////////////////////////////////////////////////////////////////////////////////////


