/*
 * Decompiled with CFR 0.152.
 */
package parquet.org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import parquet.org.codehaus.jackson.map.AnnotationIntrospector;
import parquet.org.codehaus.jackson.map.ClassIntrospector;
import parquet.org.codehaus.jackson.map.introspect.Annotated;
import parquet.org.codehaus.jackson.map.introspect.AnnotationMap;
import parquet.org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedClass
extends Annotated {
    private static final AnnotationMap[] NO_ANNOTATION_MAPS = new AnnotationMap[0];
    protected final Class<?> _class;
    protected final List<Class<?>> _superTypes;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final ClassIntrospector.MixInResolver _mixInResolver;
    protected final Class<?> _primaryMixIn;
    protected AnnotationMap _classAnnotations;

    private AnnotatedClass(Class<?> cls, List<Class<?>> superTypes, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir, AnnotationMap classAnnotations) {
        this._class = cls;
        this._superTypes = superTypes;
        this._annotationIntrospector = aintr;
        this._mixInResolver = mir;
        this._primaryMixIn = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(this._class);
        this._classAnnotations = classAnnotations;
    }

    public static AnnotatedClass constructWithoutSuperTypes(Class<?> cls, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir) {
        List<Class<?>> empty = Collections.emptyList();
        AnnotatedClass ac = new AnnotatedClass(cls, empty, aintr, mir, null);
        ac.resolveClassAnnotations();
        return ac;
    }

    public void resolveClassAnnotations() {
        this._classAnnotations = new AnnotationMap();
        if (this._annotationIntrospector == null) {
            return;
        }
        if (this._primaryMixIn != null) {
            this._addClassMixIns(this._classAnnotations, this._class, this._primaryMixIn);
        }
        for (Annotation a : this._class.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a)) continue;
            this._classAnnotations.addIfNotPresent(a);
        }
        for (Class<?> cls : this._superTypes) {
            this._addClassMixIns(this._classAnnotations, cls);
            for (Annotation a : cls.getDeclaredAnnotations()) {
                if (!this._annotationIntrospector.isHandled(a)) continue;
                this._classAnnotations.addIfNotPresent(a);
            }
        }
        this._addClassMixIns(this._classAnnotations, Object.class);
    }

    protected void _addClassMixIns(AnnotationMap annotations, Class<?> toMask) {
        if (this._mixInResolver != null) {
            this._addClassMixIns(annotations, toMask, this._mixInResolver.findMixInClassFor(toMask));
        }
    }

    protected void _addClassMixIns(AnnotationMap annotations, Class<?> toMask, Class<?> mixin) {
        if (mixin == null) {
            return;
        }
        for (Annotation a : mixin.getDeclaredAnnotations()) {
            if (!this._annotationIntrospector.isHandled(a)) continue;
            annotations.addIfNotPresent(a);
        }
        for (Class<?> parent : ClassUtil.findSuperTypes(mixin, toMask)) {
            for (Annotation a : parent.getDeclaredAnnotations()) {
                if (!this._annotationIntrospector.isHandled(a)) continue;
                annotations.addIfNotPresent(a);
            }
        }
    }

    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }
}

