/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.reflections.Configuration;
import org.reflections.adapters.JavassistAdapter;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBuilder
implements Configuration {
    private final Set<Scanner> scanners = Sets.newHashSet(new TypeAnnotationsScanner(), new SubTypesScanner());
    private Set<URL> urls = Sets.newHashSet();
    private MetadataAdapter metadataAdapter;
    private Predicate<String> inputsFilter;
    private ExecutorService executorService;
    private ClassLoader[] classLoaders;

    @Override
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scanners) {
        this.scanners.clear();
        return this.addScanners(scanners);
    }

    public ConfigurationBuilder addScanners(Scanner ... scanners) {
        this.scanners.addAll(Sets.newHashSet(scanners));
        return this;
    }

    @Override
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(Collection<URL> urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        return this.metadataAdapter != null ? this.metadataAdapter : (this.metadataAdapter = new JavassistAdapter());
    }

    @Override
    public boolean acceptsInput(String inputFqn) {
        return this.inputsFilter == null || this.inputsFilter.apply(inputFqn);
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }
}

