/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.adapters;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javax.annotation.Nullable;
import org.reflections.ReflectionsException;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistAdapter
implements MetadataAdapter<ClassFile, FieldInfo, MethodInfo> {
    public static boolean includeInvisibleTag = true;
    @Nullable
    private Cache<Vfs.File, ClassFile> classFileCache;

    public JavassistAdapter() {
        try {
            this.classFileCache = CacheBuilder.newBuilder().softValues().weakKeys().maximumSize(16L).expireAfterWrite(500L, TimeUnit.MILLISECONDS).build(new CacheLoader<Vfs.File, ClassFile>(){

                @Override
                public ClassFile load(Vfs.File key) throws Exception {
                    return JavassistAdapter.this.createClassObject(key);
                }
            });
        }
        catch (Error e) {
            this.classFileCache = null;
        }
    }

    @Override
    public List<String> getClassAnnotationNames(ClassFile aClass) {
        return this.getAnnotationNames((AnnotationsAttribute)aClass.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)aClass.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public ClassFile getOfCreateClassObject(Vfs.File file) {
        try {
            if (this.classFileCache != null) {
                return (ClassFile)((LoadingCache)this.classFileCache).get(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createClassObject(file);
    }

    protected ClassFile createClassObject(Vfs.File file) {
        InputStream inputStream = null;
        try {
            inputStream = file.openInputStream();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(inputStream));
            ClassFile classFile = new ClassFile(dis);
            return classFile;
        }
        catch (IOException e) {
            throw new ReflectionsException("could not create class file from " + file.getName(), e);
        }
        finally {
            Utils.close(inputStream);
        }
    }

    @Override
    public String getClassName(ClassFile cls) {
        return cls.getName();
    }

    @Override
    public String getSuperclassName(ClassFile cls) {
        return cls.getSuperclass();
    }

    @Override
    public List<String> getInterfacesNames(ClassFile cls) {
        return Arrays.asList(cls.getInterfaces());
    }

    private List<String> getAnnotationNames(AnnotationsAttribute ... annotationsAttributes) {
        ArrayList<String> result = Lists.newArrayList();
        if (annotationsAttributes != null) {
            for (AnnotationsAttribute annotationsAttribute : annotationsAttributes) {
                if (annotationsAttribute == null) continue;
                for (Annotation annotation : annotationsAttribute.getAnnotations()) {
                    result.add(annotation.getTypeName());
                }
            }
        }
        return result;
    }
}

