/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store {
    private final Map<String, Multimap<String, String>> storeMap;
    private final transient boolean concurrent;
    private static final transient Supplier<Set<String>> setSupplier = new Supplier<Set<String>>(){

        @Override
        public Set<String> get() {
            return Sets.newHashSet();
        }
    };

    protected Store() {
        this(false);
    }

    protected Store(boolean concurrent) {
        this.concurrent = concurrent;
        this.storeMap = new HashMap<String, Multimap<String, String>>();
    }

    private SetMultimap<String, String> createMultimap() {
        return this.concurrent ? Multimaps.synchronizedSetMultimap(Multimaps.newSetMultimap(new HashMap(), setSupplier)) : Multimaps.newSetMultimap(new HashMap(), setSupplier);
    }

    public Multimap<String, String> getOrCreate(String indexName) {
        Multimap<String, String> mmap;
        if (indexName.contains(".")) {
            indexName = indexName.substring(indexName.lastIndexOf(".") + 1);
        }
        if ((mmap = this.storeMap.get(indexName)) == null) {
            mmap = this.createMultimap();
            this.storeMap.put(indexName, mmap);
        }
        return mmap;
    }

    @Nullable
    public Multimap<String, String> get(Class<? extends Scanner> scannerClass) {
        return this.storeMap.get(scannerClass.getSimpleName());
    }

    public Set<String> get(Class<? extends Scanner> scannerClass, String ... keys) {
        HashSet<String> result = Sets.newHashSet();
        Multimap<String, String> map = this.get(scannerClass);
        if (map != null) {
            for (String key : keys) {
                result.addAll(map.get(key));
            }
        }
        return result;
    }

    public Integer getKeysCount() {
        Integer keys = 0;
        for (Multimap<String, String> multimap : this.storeMap.values()) {
            keys = keys + multimap.keySet().size();
        }
        return keys;
    }

    public Integer getValuesCount() {
        Integer values = 0;
        for (Multimap<String, String> multimap : this.storeMap.values()) {
            values = values + multimap.size();
        }
        return values;
    }

    public Set<String> getSubTypesOf(String type) {
        HashSet<String> result = new HashSet<String>();
        Set<String> subTypes = this.get(SubTypesScanner.class, type);
        result.addAll(subTypes);
        for (String subType : subTypes) {
            result.addAll(this.getSubTypesOf(subType));
        }
        return result;
    }
}

