/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

public class FormatUtils {
    private static final double LOG_10 = Math.log(10.0);

    public static void appendPaddedInteger(StringBuffer stringBuffer, int n, int n2) {
        if (n < 0) {
            stringBuffer.append('-');
            if (n != Integer.MIN_VALUE) {
                n = -n;
            } else {
                while (n2 > 10) {
                    stringBuffer.append('0');
                    --n2;
                }
                stringBuffer.append("2147483648");
                return;
            }
        }
        if (n < 10) {
            while (n2 > 1) {
                stringBuffer.append('0');
                --n2;
            }
            stringBuffer.append((char)(n + 48));
        } else if (n < 100) {
            while (n2 > 2) {
                stringBuffer.append('0');
                --n2;
            }
            int n3 = (n + 1) * 0xCCCCCC >> 27;
            stringBuffer.append((char)(n3 + 48));
            stringBuffer.append((char)(n - (n3 << 3) - (n3 << 1) + 48));
        } else {
            int n4 = n < 1000 ? 3 : (n < 10000 ? 4 : (int)(Math.log(n) / LOG_10) + 1);
            while (n2 > n4) {
                stringBuffer.append('0');
                --n2;
            }
            stringBuffer.append(Integer.toString(n));
        }
    }

    public static void appendUnpaddedInteger(StringBuffer stringBuffer, int n) {
        if (n < 0) {
            stringBuffer.append('-');
            if (n != Integer.MIN_VALUE) {
                n = -n;
            } else {
                stringBuffer.append("2147483648");
                return;
            }
        }
        if (n < 10) {
            stringBuffer.append((char)(n + 48));
        } else if (n < 100) {
            int n2 = (n + 1) * 0xCCCCCC >> 27;
            stringBuffer.append((char)(n2 + 48));
            stringBuffer.append((char)(n - (n2 << 3) - (n2 << 1) + 48));
        } else {
            stringBuffer.append(Integer.toString(n));
        }
    }

    public static int calculateDigitCount(long l) {
        if (l < 0L) {
            if (l != Long.MIN_VALUE) {
                return FormatUtils.calculateDigitCount(-l) + 1;
            }
            return 20;
        }
        return l < 10L ? 1 : (l < 100L ? 2 : (l < 1000L ? 3 : (l < 10000L ? 4 : (int)(Math.log(l) / LOG_10) + 1)));
    }

    static int parseTwoDigits(String string, int n) {
        int n2 = string.charAt(n) - 48;
        return (n2 << 3) + (n2 << 1) + string.charAt(n + 1) - 48;
    }

    static String createErrorMessage(String string, int n) {
        int n2 = n + 32;
        String string2 = string.length() <= n2 + 3 ? string : string.substring(0, n2).concat("...");
        if (n <= 0) {
            return "Invalid format: \"" + string2 + '\"';
        }
        if (n >= string.length()) {
            return "Invalid format: \"" + string2 + "\" is too short";
        }
        return "Invalid format: \"" + string2 + "\" is malformed at \"" + string2.substring(n) + '\"';
    }
}

