/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class DateTimeFormat {
    private static final Map<String, DateTimeFormatter> PATTERN_CACHE = new LinkedHashMap<String, DateTimeFormatter>(7){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, DateTimeFormatter> entry) {
            return this.size() > 500;
        }
    };
    private static final DateTimeFormatter[] STYLE_CACHE = new DateTimeFormatter[25];

    public static DateTimeFormatter forPattern(String string) {
        return DateTimeFormat.createFormatterForPattern(string);
    }

    private static void parsePatternTo(DateTimeFormatterBuilder dateTimeFormatterBuilder, String string) {
        int n = string.length();
        int[] nArray = new int[1];
        block30: for (int i = 0; i < n; ++i) {
            nArray[0] = i;
            String string2 = DateTimeFormat.parseToken(string, nArray);
            i = nArray[0];
            int n2 = string2.length();
            if (n2 == 0) break;
            char c = string2.charAt(0);
            switch (c) {
                case 'G': {
                    dateTimeFormatterBuilder.appendEraText();
                    continue block30;
                }
                case 'C': {
                    dateTimeFormatterBuilder.appendCenturyOfEra(n2, n2);
                    continue block30;
                }
                case 'Y': 
                case 'x': 
                case 'y': {
                    if (n2 == 2) {
                        boolean bl = true;
                        if (i + 1 < n) {
                            nArray[0] = nArray[0] + 1;
                            if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(string, nArray))) {
                                bl = false;
                            }
                            nArray[0] = nArray[0] - 1;
                        }
                        switch (c) {
                            case 'x': {
                                dateTimeFormatterBuilder.appendTwoDigitWeekyear(new DateTime().getWeekyear() - 30, bl);
                                continue block30;
                            }
                        }
                        dateTimeFormatterBuilder.appendTwoDigitYear(new DateTime().getYear() - 30, bl);
                        continue block30;
                    }
                    int n3 = 9;
                    if (i + 1 < n) {
                        nArray[0] = nArray[0] + 1;
                        if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(string, nArray))) {
                            n3 = n2;
                        }
                        nArray[0] = nArray[0] - 1;
                    }
                    switch (c) {
                        case 'x': {
                            dateTimeFormatterBuilder.appendWeekyear(n2, n3);
                            break;
                        }
                        case 'y': {
                            dateTimeFormatterBuilder.appendYear(n2, n3);
                            break;
                        }
                        case 'Y': {
                            dateTimeFormatterBuilder.appendYearOfEra(n2, n3);
                        }
                    }
                    continue block30;
                }
                case 'M': {
                    if (n2 >= 3) {
                        if (n2 >= 4) {
                            dateTimeFormatterBuilder.appendMonthOfYearText();
                            continue block30;
                        }
                        dateTimeFormatterBuilder.appendMonthOfYearShortText();
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendMonthOfYear(n2);
                    continue block30;
                }
                case 'd': {
                    dateTimeFormatterBuilder.appendDayOfMonth(n2);
                    continue block30;
                }
                case 'a': {
                    dateTimeFormatterBuilder.appendHalfdayOfDayText();
                    continue block30;
                }
                case 'h': {
                    dateTimeFormatterBuilder.appendClockhourOfHalfday(n2);
                    continue block30;
                }
                case 'H': {
                    dateTimeFormatterBuilder.appendHourOfDay(n2);
                    continue block30;
                }
                case 'k': {
                    dateTimeFormatterBuilder.appendClockhourOfDay(n2);
                    continue block30;
                }
                case 'K': {
                    dateTimeFormatterBuilder.appendHourOfHalfday(n2);
                    continue block30;
                }
                case 'm': {
                    dateTimeFormatterBuilder.appendMinuteOfHour(n2);
                    continue block30;
                }
                case 's': {
                    dateTimeFormatterBuilder.appendSecondOfMinute(n2);
                    continue block30;
                }
                case 'S': {
                    dateTimeFormatterBuilder.appendFractionOfSecond(n2, n2);
                    continue block30;
                }
                case 'e': {
                    dateTimeFormatterBuilder.appendDayOfWeek(n2);
                    continue block30;
                }
                case 'E': {
                    if (n2 >= 4) {
                        dateTimeFormatterBuilder.appendDayOfWeekText();
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendDayOfWeekShortText();
                    continue block30;
                }
                case 'D': {
                    dateTimeFormatterBuilder.appendDayOfYear(n2);
                    continue block30;
                }
                case 'w': {
                    dateTimeFormatterBuilder.appendWeekOfWeekyear(n2);
                    continue block30;
                }
                case 'z': {
                    if (n2 >= 4) {
                        dateTimeFormatterBuilder.appendTimeZoneName();
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendTimeZoneShortName(null);
                    continue block30;
                }
                case 'Z': {
                    if (n2 == 1) {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, "Z", false, 2, 2);
                        continue block30;
                    }
                    if (n2 == 2) {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, "Z", true, 2, 2);
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendTimeZoneId();
                    continue block30;
                }
                case '\'': {
                    String string3 = string2.substring(1);
                    if (string3.length() == 1) {
                        dateTimeFormatterBuilder.appendLiteral(string3.charAt(0));
                        continue block30;
                    }
                    dateTimeFormatterBuilder.appendLiteral(new String(string3));
                    continue block30;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string2);
                }
            }
        }
    }

    private static String parseToken(String string, int[] nArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        char c = string.charAt(n);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            char c2;
            stringBuilder.append(c);
            while (n + 1 < n2 && (c2 = string.charAt(n + 1)) == c) {
                stringBuilder.append(c);
                ++n;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n = nArray[0]; n < n2; ++n) {
                c = string.charAt(n);
                if (c == '\'') {
                    if (n + 1 < n2 && string.charAt(n + 1) == '\'') {
                        ++n;
                        stringBuilder.append(c);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) {
                    stringBuilder.append(c);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n;
        return stringBuilder.toString();
    }

    private static boolean isNumericToken(String string) {
        int n = string.length();
        if (n > 0) {
            char c = string.charAt(0);
            switch (c) {
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'x': 
                case 'y': {
                    return true;
                }
                case 'M': {
                    if (n > 2) break;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateTimeFormatter createFormatterForPattern(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        DateTimeFormatter dateTimeFormatter = null;
        Map<String, DateTimeFormatter> map = PATTERN_CACHE;
        synchronized (map) {
            dateTimeFormatter = PATTERN_CACHE.get(string);
            if (dateTimeFormatter == null) {
                DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
                DateTimeFormat.parsePatternTo(dateTimeFormatterBuilder, string);
                dateTimeFormatter = dateTimeFormatterBuilder.toFormatter();
                PATTERN_CACHE.put(string, dateTimeFormatter);
            }
        }
        return dateTimeFormatter;
    }
}

