/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractPeriod;

public abstract class BasePeriod
extends AbstractPeriod
implements Serializable,
ReadablePeriod {
    private static final ReadablePeriod DUMMY_PERIOD = new AbstractPeriod(){

        public int getValue(int n) {
            return 0;
        }

        public PeriodType getPeriodType() {
            return PeriodType.time();
        }
    };
    private final PeriodType iType;
    private final int[] iValues;

    protected BasePeriod(long l, PeriodType periodType, Chronology chronology) {
        periodType = this.checkPeriodType(periodType);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iType = periodType;
        this.iValues = chronology.get(this, l);
    }

    protected BasePeriod(int[] nArray, PeriodType periodType) {
        this.iType = periodType;
        this.iValues = nArray;
    }

    protected PeriodType checkPeriodType(PeriodType periodType) {
        return DateTimeUtils.getPeriodType(periodType);
    }

    public PeriodType getPeriodType() {
        return this.iType;
    }

    public int getValue(int n) {
        return this.iValues[n];
    }
}

