/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDateTime;
import org.joda.time.base.AbstractDateTime;
import org.joda.time.chrono.ISOChronology;

public abstract class BaseDateTime
extends AbstractDateTime
implements Serializable,
ReadableDateTime {
    private volatile long iMillis;
    private volatile Chronology iChronology;

    public BaseDateTime() {
        this(DateTimeUtils.currentTimeMillis(), ISOChronology.getInstance());
    }

    public BaseDateTime(long l) {
        this(l, ISOChronology.getInstance());
    }

    public BaseDateTime(long l, DateTimeZone dateTimeZone) {
        this(l, ISOChronology.getInstance(dateTimeZone));
    }

    public BaseDateTime(long l, Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
        this.iMillis = this.checkInstant(l, this.iChronology);
    }

    protected Chronology checkChronology(Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    protected long checkInstant(long l, Chronology chronology) {
        return l;
    }

    public long getMillis() {
        return this.iMillis;
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected void setMillis(long l) {
        this.iMillis = this.checkInstant(l, this.iChronology);
    }
}

