/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeUtils {
    private static final SystemMillisProvider SYSTEM_MILLIS_PROVIDER = new SystemMillisProvider();
    private static volatile MillisProvider cMillisProvider = SYSTEM_MILLIS_PROVIDER;
    private static volatile Map<String, DateTimeZone> cZoneNames;

    private static void put(Map<String, DateTimeZone> map, String string, String string2) {
        try {
            map.put(string, DateTimeZone.forID(string2));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static final long currentTimeMillis() {
        return cMillisProvider.getMillis();
    }

    public static final long getInstantMillis(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return DateTimeUtils.currentTimeMillis();
        }
        return readableInstant.getMillis();
    }

    public static final Chronology getInstantChronology(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return ISOChronology.getInstance();
        }
        Chronology chronology = readableInstant.getChronology();
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final Chronology getChronology(Chronology chronology) {
        if (chronology == null) {
            return ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final DateTimeZone getZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            return DateTimeZone.getDefault();
        }
        return dateTimeZone;
    }

    public static final PeriodType getPeriodType(PeriodType periodType) {
        if (periodType == null) {
            return PeriodType.standard();
        }
        return periodType;
    }

    public static final DateFormatSymbols getDateFormatSymbols(Locale locale) {
        try {
            Method method = DateFormatSymbols.class.getMethod("getInstance", Locale.class);
            return (DateFormatSymbols)method.invoke(null, locale);
        }
        catch (Exception exception) {
            return new DateFormatSymbols(locale);
        }
    }

    public static final Map<String, DateTimeZone> getDefaultTimeZoneNames() {
        return cZoneNames;
    }

    static {
        LinkedHashMap<String, DateTimeZone> linkedHashMap = new LinkedHashMap<String, DateTimeZone>();
        linkedHashMap.put("UT", DateTimeZone.UTC);
        linkedHashMap.put("UTC", DateTimeZone.UTC);
        linkedHashMap.put("GMT", DateTimeZone.UTC);
        DateTimeUtils.put(linkedHashMap, "EST", "America/New_York");
        DateTimeUtils.put(linkedHashMap, "EDT", "America/New_York");
        DateTimeUtils.put(linkedHashMap, "CST", "America/Chicago");
        DateTimeUtils.put(linkedHashMap, "CDT", "America/Chicago");
        DateTimeUtils.put(linkedHashMap, "MST", "America/Denver");
        DateTimeUtils.put(linkedHashMap, "MDT", "America/Denver");
        DateTimeUtils.put(linkedHashMap, "PST", "America/Los_Angeles");
        DateTimeUtils.put(linkedHashMap, "PDT", "America/Los_Angeles");
        cZoneNames = Collections.unmodifiableMap(linkedHashMap);
    }

    static class SystemMillisProvider
    implements MillisProvider {
        SystemMillisProvider() {
        }

        public long getMillis() {
            return System.currentTimeMillis();
        }
    }

    public static interface MillisProvider {
        public long getMillis();
    }
}

