/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.logging;

import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.JdkLoggerFactory;
import org.jboss.netty.util.internal.StackTraceSimplifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory = new JdkLoggerFactory();

    public static InternalLoggerFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String name) {
        final InternalLogger logger = InternalLoggerFactory.getDefaultFactory().newInstance(name);
        return new InternalLogger(){

            public void warn(String msg) {
                logger.warn(msg);
            }

            public void warn(String msg, Throwable cause) {
                StackTraceSimplifier.simplify(cause);
                logger.warn(msg, cause);
            }
        };
    }

    public abstract InternalLogger newInstance(String var1);

    static {
        StackTraceSimplifier.simplify(new Exception());
    }
}

