/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.replay;

import java.nio.ByteOrder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.replay.ReplayError;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.UnreplayableOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplayingDecoderBuffer
implements ChannelBuffer {
    private static final Error REPLAY = new ReplayError();
    private final ReplayingDecoder<?> parent;
    private boolean terminated;

    ReplayingDecoderBuffer(ReplayingDecoder<?> parent) {
        this.parent = parent;
    }

    private ChannelBuffer buf() {
        return this.parent.internalBuffer();
    }

    @Override
    public int capacity() {
        if (this.terminated) {
            return this.buf().capacity();
        }
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(ChannelBuffer buffer) {
        throw new UnreplayableOperationException();
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index, 1);
        return this.buf().getByte(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        this.checkIndex(index, 1);
        return this.buf().getUnsignedByte(index);
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        return this.buf().getInt(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        this.checkIndex(index, 4);
        return this.buf().getUnsignedInt(index);
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        return this.buf().getLong(index);
    }

    public int hashCode() {
        throw new UnreplayableOperationException();
    }

    @Override
    public ByteOrder order() {
        return this.buf().order();
    }

    @Override
    public int readableBytes() {
        if (this.terminated) {
            return this.buf().readableBytes();
        }
        return Integer.MAX_VALUE - this.buf().readerIndex();
    }

    @Override
    public int readerIndex() {
        return this.buf().readerIndex();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + "ridx=" + this.readerIndex() + ", " + "widx=" + this.writerIndex() + ')';
    }

    @Override
    public int writerIndex() {
        return this.buf().writerIndex();
    }

    private void checkIndex(int index, int length) {
        if (index + length > this.buf().writerIndex()) {
            throw REPLAY;
        }
    }
}

