/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util14;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class NumberUtil {
    private static final DecimalFormat FLOAT_FORMATTER = new DecimalFormat();
    private static final DecimalFormat DOUBLE_FORMATTER;
    private static final BigInteger[] BIG_INT_TEN_POW;
    private static final BigInteger[] BIG_INT_MIN_UNSCALED;
    private static final BigInteger[] BIG_INT_MAX_UNSCALED;

    public static BigDecimal rescaleBigDecimal(BigDecimal bd, int scale) {
        if (bd != null) {
            bd = bd.setScale(scale, 4);
        }
        return bd;
    }

    static {
        FLOAT_FORMATTER.applyPattern("0.######E0");
        DOUBLE_FORMATTER = new DecimalFormat();
        DOUBLE_FORMATTER.applyPattern("0.###############E0");
        BIG_INT_TEN_POW = new BigInteger[20];
        BIG_INT_MIN_UNSCALED = new BigInteger[20];
        BIG_INT_MAX_UNSCALED = new BigInteger[20];
        for (int i = 0; i < BIG_INT_TEN_POW.length; ++i) {
            NumberUtil.BIG_INT_TEN_POW[i] = BigInteger.TEN.pow(i);
            if (i < 19) {
                NumberUtil.BIG_INT_MAX_UNSCALED[i] = BIG_INT_TEN_POW[i].subtract(BigInteger.ONE);
                NumberUtil.BIG_INT_MIN_UNSCALED[i] = BIG_INT_MAX_UNSCALED[i].negate();
                continue;
            }
            NumberUtil.BIG_INT_MAX_UNSCALED[i] = BigInteger.valueOf(Long.MAX_VALUE);
            NumberUtil.BIG_INT_MIN_UNSCALED[i] = BigInteger.valueOf(Long.MIN_VALUE);
        }
    }
}

