/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eigenbase.util.CastingList;
import org.eigenbase.util.ControlFlowException;
import org.eigenbase.util.SaffronProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static boolean driversLoaded = false;
    private static final Pattern JAVA_ID_PATTERN = Pattern.compile("[a-zA-Z_$][a-zA-Z0-9$]*");
    private static final LoadingCache<Class, Map<String, Enum>> ENUM_CONSTANTS = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class, Map<String, Enum>>(){

        @Override
        public Map<String, Enum> load(Class clazz) {
            return Util.enumConstants(clazz);
        }
    });

    private Util() {
    }

    public static void discard(Object o) {
    }

    public static void discard(int i) {
    }

    public static boolean discard(boolean b) {
        return b;
    }

    public static void swallow(Throwable e, Logger logger) {
        if (logger != null) {
            logger.log(Level.FINER, "Discarding exception", e);
        }
    }

    public static boolean equal(Object s0, Object s1) {
        if (s0 == s1) {
            return true;
        }
        if (s0 == null) {
            return false;
        }
        return s0.equals(s1);
    }

    public static <T> boolean equalShallow(List<? extends T> list0, List<? extends T> list1) {
        if (list0.size() != list1.size()) {
            return false;
        }
        for (int i = 0; i < list0.size(); ++i) {
            if (list0.get(i) == list1.get(i)) continue;
            return false;
        }
        return true;
    }

    public static int hash(int i, int j) {
        return i << 4 ^ j;
    }

    public static int hash(int h, Object o) {
        int k = o == null ? 0 : o.hashCode();
        return (h << 4 | h) ^ k;
    }

    public static int hashV(Object ... a) {
        int h = 19690721;
        for (Object o : a) {
            h = Util.hash(h, o);
        }
        return h;
    }

    public static int hashCode(double v) {
        long bits = Double.doubleToLongBits(v);
        return (int)(bits ^ bits >>> 32);
    }

    public static <T> Set<T> minus(Set<T> set1, Set<T> set2) {
        if (set1.isEmpty()) {
            return set1;
        }
        if (set2.isEmpty()) {
            return set1;
        }
        HashSet<T> set = new HashSet<T>(set1);
        set.removeAll(set2);
        return set;
    }

    public static void printJavaString(PrintWriter pw, String s, boolean nullMeansNull) {
        if (s == null) {
            if (nullMeansNull) {
                pw.print("null");
            }
        } else {
            String s1 = Util.replace(s, "\\", "\\\\");
            String s2 = Util.replace(s1, "\"", "\\\"");
            String s3 = Util.replace(s2, "\n\r", "\\n");
            String s4 = Util.replace(s3, "\n", "\\n");
            String s5 = Util.replace(s4, "\r", "\\r");
            pw.print("\"");
            pw.print(s5);
            pw.print("\"");
        }
    }

    public static String toScientificNotation(BigDecimal bd) {
        int truncateAt = 20;
        String unscaled = bd.unscaledValue().toString();
        if (bd.signum() < 0) {
            unscaled = unscaled.substring(1);
        }
        int len = unscaled.length();
        int scale = bd.scale();
        int e = len - scale - 1;
        StringBuilder ret = new StringBuilder();
        if (bd.signum() < 0) {
            ret.append('-');
        }
        unscaled = unscaled.substring(0, Math.min(20, len));
        ret.append(unscaled.charAt(0));
        if (scale == 0) {
            int i;
            for (i = unscaled.length(); i > 1 && unscaled.charAt(i - 1) == '0'; --i) {
            }
            unscaled = unscaled.substring(0, i);
        }
        if (unscaled.length() > 1) {
            ret.append(".");
            ret.append(unscaled.substring(1));
        }
        ret.append("E");
        ret.append(e);
        return ret.toString();
    }

    public static String replace(String s, String find, String replace) {
        int found = s.indexOf(find);
        if (found == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int start = 0;
        while (true) {
            if (start < found) {
                sb.append(s.charAt(start));
                ++start;
                continue;
            }
            if (found == s.length()) break;
            sb.append(replace);
            found = s.indexOf(find, start += find.length());
            if (found != -1) continue;
            found = s.length();
        }
        return sb.toString();
    }

    public static String toJavaId(String s, int ordinal) {
        if (JAVA_ID_PATTERN.matcher(s).matches()) {
            return "ID$" + ordinal + "$" + s;
        }
        StringBuilder buf = new StringBuilder(s.length() + 10);
        buf.append("ID$");
        buf.append(ordinal);
        buf.append("$");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                buf.append("__");
                continue;
            }
            if (c < '\u007f' && !Character.isISOControl(c) && (i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c))) {
                buf.append(c);
                continue;
            }
            buf.append("_");
            buf.append(Integer.toString(c, 16));
            buf.append("_");
        }
        return buf.toString();
    }

    public static boolean isNullOrEmpty(String s) {
        return null == s || s.length() == 0;
    }

    public static <T> String sepList(List<T> list, String sep) {
        int max = list.size() - 1;
        switch (max) {
            case -1: {
                return "";
            }
            case 0: {
                return list.get(0).toString();
            }
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (true) {
            buf.append(list.get(i));
            if (i == max) {
                return buf.toString();
            }
            buf.append(sep);
            ++i;
        }
    }

    public static Charset getDefaultCharset() {
        return Charset.forName(SaffronProperties.instance().defaultCharset.get());
    }

    public static Error newInternal() {
        return Util.newInternal("(unknown cause)");
    }

    public static Error newInternal(String s) {
        return new AssertionError((Object)("Internal error: " + s));
    }

    public static Error newInternal(Throwable e) {
        return Util.newInternal(e, "(unknown cause)");
    }

    public static Error newInternal(Throwable e, String s) {
        String message = "Internal error: " + s;
        AssertionError ae = new AssertionError((Object)message);
        ((Throwable)((Object)ae)).initCause(e);
        return ae;
    }

    public static void pre(boolean b, String description) {
        if (!b) {
            throw Util.newInternal("pre-condition failed: " + description);
        }
    }

    public static void permAssert(boolean b, String description) {
        if (!b) {
            throw Util.newInternal("invariant violated: " + description);
        }
    }

    public static RuntimeException needToImplement(Object o) {
        String description = null;
        if (o != null) {
            description = o.getClass().toString() + ": " + o.toString();
        }
        throw new UnsupportedOperationException(description);
    }

    public static String rpad(String s, int len) {
        if (s.length() >= len) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < len) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static <E> List<E> cast(List<? super E> list, Class<E> clazz) {
        return new CastingList<E>(list, clazz);
    }

    public static <K, V> Map<K, V> mapOf(K key, V value, Object ... keyValues) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(1 + keyValues.length);
        map.put(key, value);
        int i = 0;
        while (i < keyValues.length) {
            map.put(keyValues[i++], keyValues[i++]);
        }
        return map;
    }

    public static <E extends Enum<E>> Error unexpected(E value) {
        return new AssertionError((Object)("Was not expecting value '" + value + "' for enumeration '" + value.getDeclaringClass().getName() + "' in this context"));
    }

    public static <T extends Enum<T>> Map<String, T> enumConstants(Class<T> clazz) {
        Enum[] ts = (Enum[])clazz.getEnumConstants();
        if (ts == null) {
            return null;
        }
        ImmutableMap.Builder<String, Enum> builder = ImmutableMap.builder();
        for (Enum t : ts) {
            builder.put(t.name(), t);
        }
        return builder.build();
    }

    public static synchronized <T extends Enum<T>> T enumVal(Class<T> clazz, String name) {
        return (T)ENUM_CONSTANTS.getUnchecked(clazz).get(name);
    }

    public static <E> List<E> quotientList(final List<E> list, final int n, final int k) {
        if (n <= 0 || k < 0 || k >= n) {
            throw new IllegalArgumentException("n must be positive; k must be between 0 and n - 1");
        }
        final int size = (list.size() + n - k - 1) / n;
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return list.get(index * n + k);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static <T> T first(T t0, T t1) {
        return t0 != null ? t0 : t1;
    }

    public static <E> E last(List<E> list) {
        return list.get(list.size() - 1);
    }

    public static <E> List<E> skipLast(List<E> list) {
        return Util.skipLast(list, 1);
    }

    public static <E> List<E> skipLast(List<E> list, int n) {
        return list.subList(0, list.size() - n);
    }

    public static <E> List<E> last(List<E> list, int n) {
        return list.subList(list.size() - n, list.size());
    }

    public static <E> List<E> skip(List<E> list) {
        return Util.skip(list, 1);
    }

    public static <E> List<E> skip(List<E> list, int fromIndex) {
        return list.subList(fromIndex, list.size());
    }

    public static List<Integer> range(final int start, final int end) {
        return new AbstractList<Integer>(){

            @Override
            public int size() {
                return end - start;
            }

            @Override
            public Integer get(int index) {
                return start + index;
            }
        };
    }

    public static String toCamelCase(String name) {
        StringBuilder buf = new StringBuilder();
        int nextUpper = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                nextUpper = i + 1;
                continue;
            }
            c = nextUpper == i ? Character.toUpperCase(c) : Character.toLowerCase(c);
            buf.append(c);
        }
        return buf.toString();
    }

    public static String camelToUpper(String name) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buf.append('_');
            } else {
                c = Character.toUpperCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static <E> boolean isDistinct(List<E> list) {
        return Util.firstDuplicate(list) < 0;
    }

    public static <E> int firstDuplicate(List<E> list) {
        int size = list.size();
        if (size < 2) {
            return -1;
        }
        if (size < 15) {
            for (int i = 1; i < size; ++i) {
                E e = list.get(i);
                for (int j = i - 1; j >= 0; --j) {
                    E e1 = list.get(j);
                    if (!Util.equal(e, e1)) continue;
                    return i;
                }
            }
            return -1;
        }
        HashMap<E, String> set = new HashMap<E, String>(size);
        for (E e : list) {
            if (set.put(e, "") == null) continue;
            return set.size();
        }
        return -1;
    }

    public static int match2(List<String> strings, String name, boolean caseSensitive1) {
        if (caseSensitive1) {
            return strings.indexOf(name);
        }
        for (int i = 0; i < strings.size(); ++i) {
            String s = strings.get(i);
            if (!s.equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public static boolean match(boolean caseSensitive, String name1, String name0) {
        return caseSensitive ? name0.equals(name1) : name0.equalsIgnoreCase(name1);
    }

    public static <E> boolean startsWith(List<E> list0, List<E> list1) {
        return list0.equals(list1) || list0.size() > list1.size() && list0.subList(0, list1.size()).equals(list1);
    }

    public static class FoundOne
    extends ControlFlowException {
        private final Object node;
        public static final FoundOne NULL = new FoundOne((Object)null);

        public FoundOne(Object node) {
            this.node = node;
        }

        public Object getNode() {
            return this.node;
        }
    }
}

