/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eigenbase.util.ReflectiveVisitDispatcher;
import org.eigenbase.util.ReflectiveVisitor;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectUtil {
    private static Map<Class, Class> primitiveToBoxingMap = new HashMap<Class, Class>();
    private static Map<Class, Method> primitiveToByteBufferReadMethod;
    private static Map<Class, Method> primitiveToByteBufferWriteMethod;

    public static boolean invokeVisitor(ReflectiveVisitor visitor, Object visitee, Class hierarchyRoot, String visitMethodName) {
        return ReflectUtil.invokeVisitorInternal(visitor, visitee, hierarchyRoot, visitMethodName);
    }

    private static boolean invokeVisitorInternal(Object visitor, Object visitee, Class hierarchyRoot, String visitMethodName) {
        Class<?> paramType;
        Class<?> visiteeClass;
        Class<?> visitorClass = visitor.getClass();
        Method method = ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass = visitee.getClass(), visitMethodName);
        if (method == null) {
            return false;
        }
        if (hierarchyRoot != null && !hierarchyRoot.isAssignableFrom(paramType = method.getParameterTypes()[0])) {
            return false;
        }
        try {
            method.invoke(visitor, visitee);
        }
        catch (IllegalAccessException ex) {
            throw Util.newInternal(ex);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new AssertionError((Object)t.getClass().getName());
        }
        return true;
    }

    public static Method lookupVisitMethod(Class<?> visitorClass, Class<?> visiteeClass, String visitMethodName) {
        return ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, Collections.<Class>emptyList());
    }

    public static Method lookupVisitMethod(Class<?> visitorClass, Class<?> visiteeClass, String visitMethodName, List<Class> additionalParameterTypes) {
        Class[] paramTypes = new Class[1 + additionalParameterTypes.size()];
        int iParam = 0;
        paramTypes[iParam++] = null;
        for (Class paramType : additionalParameterTypes) {
            paramTypes[iParam++] = paramType;
        }
        HashMap cache = new HashMap();
        return ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, paramTypes, cache);
    }

    private static Method lookupVisitMethod(Class<?> visitorClass, Class<?> visiteeClass, String visitMethodName, Class<?>[] paramTypes, Map<Class<?>, Method> cache) {
        if (cache.containsKey(visiteeClass)) {
            return cache.get(visiteeClass);
        }
        Method candidateMethod = null;
        paramTypes[0] = visiteeClass;
        try {
            candidateMethod = visitorClass.getMethod(visitMethodName, paramTypes);
            cache.put(visiteeClass, candidateMethod);
            return candidateMethod;
        }
        catch (NoSuchMethodException ex) {
            Class<?> superClass = visiteeClass.getSuperclass();
            if (superClass != null) {
                candidateMethod = ReflectUtil.lookupVisitMethod(visitorClass, superClass, visitMethodName, paramTypes, cache);
            }
            Class<?>[] interfaces = visiteeClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = ReflectUtil.lookupVisitMethod(visitorClass, interfaces[i], visitMethodName, paramTypes, cache);
                if (method == null) continue;
                if (candidateMethod != null && !method.equals(candidateMethod)) {
                    Class<?> c2;
                    Class<?> c1 = method.getParameterTypes()[0];
                    if (c1.isAssignableFrom(c2 = candidateMethod.getParameterTypes()[0])) continue;
                    if (!c2.isAssignableFrom(c1)) {
                        throw new IllegalArgumentException("dispatch ambiguity between " + candidateMethod + " and " + method);
                    }
                }
                candidateMethod = method;
            }
            cache.put(visiteeClass, candidateMethod);
            return candidateMethod;
        }
    }

    public static <R extends ReflectiveVisitor, E> ReflectiveVisitDispatcher<R, E> createDispatcher(Class<R> visitorBaseClazz, final Class<E> visiteeBaseClazz) {
        assert (ReflectiveVisitor.class.isAssignableFrom(visitorBaseClazz));
        assert (Object.class.isAssignableFrom(visiteeBaseClazz));
        return new ReflectiveVisitDispatcher<R, E>(){
            final Map<List<Object>, Method> map = new HashMap<List<Object>, Method>();

            @Override
            public Method lookupVisitMethod(Class<? extends R> visitorClass, Class<? extends E> visiteeClass, String visitMethodName, List<Class> additionalParameterTypes) {
                ImmutableList<List<Class>> key = ImmutableList.of(visitorClass, visiteeClass, visitMethodName, additionalParameterTypes);
                Method method = this.map.get(key);
                if (method == null && !this.map.containsKey(key)) {
                    method = ReflectUtil.lookupVisitMethod(visitorClass, visiteeClass, visitMethodName, additionalParameterTypes);
                    this.map.put(key, method);
                }
                return method;
            }

            @Override
            public boolean invokeVisitor(R visitor, E visitee, String visitMethodName) {
                return ReflectUtil.invokeVisitor(visitor, visitee, visiteeBaseClazz, visitMethodName);
            }
        };
    }

    public static <E, T> MethodDispatcher<T> createMethodDispatcher(final Class<T> returnClazz, final ReflectiveVisitor visitor, final String methodName, final Class<E> arg0Clazz, Class ... otherArgClasses) {
        final ImmutableList<Class> otherArgClassList = ImmutableList.copyOf(otherArgClasses);
        final ReflectiveVisitDispatcher<?, E> dispatcher = ReflectUtil.createDispatcher(visitor.getClass(), arg0Clazz);
        return new MethodDispatcher<T>(){

            @Override
            public T invoke(Object ... args) {
                Method method = this.lookupMethod(args[0]);
                try {
                    Object o = method.invoke((Object)visitor, args);
                    return returnClazz.cast(o);
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e, "While invoking method '" + method + "'");
                }
                catch (InvocationTargetException e) {
                    throw Util.newInternal(e, "While invoking method '" + method + "'");
                }
            }

            private Method lookupMethod(Object arg0) {
                if (!arg0Clazz.isInstance(arg0)) {
                    throw new IllegalArgumentException();
                }
                Method method = dispatcher.lookupVisitMethod(visitor.getClass(), arg0.getClass(), methodName, otherArgClassList);
                if (method == null) {
                    ArrayList<Class> classList = new ArrayList<Class>();
                    classList.add(arg0Clazz);
                    classList.addAll(otherArgClassList);
                    throw new IllegalArgumentException("Method not found: " + methodName + "(" + classList + ")");
                }
                return method;
            }
        };
    }

    static {
        primitiveToBoxingMap.put(Boolean.TYPE, Boolean.class);
        primitiveToBoxingMap.put(Byte.TYPE, Byte.class);
        primitiveToBoxingMap.put(Character.TYPE, Character.class);
        primitiveToBoxingMap.put(Double.TYPE, Double.class);
        primitiveToBoxingMap.put(Float.TYPE, Float.class);
        primitiveToBoxingMap.put(Integer.TYPE, Integer.class);
        primitiveToBoxingMap.put(Long.TYPE, Long.class);
        primitiveToBoxingMap.put(Short.TYPE, Short.class);
        primitiveToByteBufferReadMethod = new HashMap<Class, Method>();
        primitiveToByteBufferWriteMethod = new HashMap<Class, Method>();
        Method[] methods = ByteBuffer.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] paramTypes = method.getParameterTypes();
            if (method.getName().startsWith("get")) {
                if (!method.getReturnType().isPrimitive() || paramTypes.length != 1) continue;
                primitiveToByteBufferReadMethod.put(method.getReturnType(), method);
                if (!method.getReturnType().equals(Byte.TYPE)) continue;
                primitiveToByteBufferReadMethod.put(Boolean.TYPE, method);
                continue;
            }
            if (!method.getName().startsWith("put") || paramTypes.length != 2 || !paramTypes[1].isPrimitive()) continue;
            primitiveToByteBufferWriteMethod.put(paramTypes[1], method);
            if (!paramTypes[1].equals(Byte.TYPE)) continue;
            primitiveToByteBufferWriteMethod.put(Boolean.TYPE, method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MethodDispatcher<T> {
        public T invoke(Object ... var1);
    }
}

