/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.parser;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hydromatic.avatica.Casing;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIntervalLiteral;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlPostfixOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.EigenbaseContextException;
import org.eigenbase.util.SaffronProperties;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlParserUtil {
    static final Logger LOGGER = EigenbaseTrace.getParserTracer();

    private SqlParserUtil() {
    }

    public static String getCharacterSet(String s) {
        if (s.charAt(0) == '\'') {
            return null;
        }
        if (Character.toUpperCase(s.charAt(0)) == 'N') {
            return SaffronProperties.instance().defaultNationalCharset.get();
        }
        int i = s.indexOf("'");
        return s.substring(1, i);
    }

    public static String parseString(String s) {
        int i = s.indexOf("'");
        if (i > 0) {
            s = s.substring(i);
        }
        return SqlParserUtil.strip(s, "'", "'", "''", Casing.UNCHANGED);
    }

    public static BigDecimal parseDecimal(String s) {
        return new BigDecimal(s);
    }

    public static BigDecimal parseInteger(String s) {
        return new BigDecimal(s);
    }

    public static long intervalToMillis(SqlIntervalLiteral.IntervalValue interval) {
        return SqlParserUtil.intervalToMillis(interval.getIntervalLiteral(), interval.getIntervalQualifier());
    }

    public static long intervalToMillis(String literal, SqlIntervalQualifier intervalQualifier) {
        int[] ret;
        Util.permAssert(!intervalQualifier.isYearMonth(), "interval must be day time");
        try {
            ret = intervalQualifier.evaluateIntervalLiteral(literal, intervalQualifier.getParserPosition());
            assert (ret != null);
        }
        catch (EigenbaseContextException e) {
            throw Util.newInternal(e, "while parsing day-to-second interval " + literal);
        }
        long l = 0L;
        long[] conv = new long[5];
        conv[4] = 1L;
        conv[3] = conv[4] * 1000L;
        conv[2] = conv[3] * 60L;
        conv[1] = conv[2] * 60L;
        conv[0] = conv[1] * 24L;
        for (int i = 1; i < ret.length; ++i) {
            l += conv[i - 1] * (long)ret[i];
        }
        return (long)ret[0] * l;
    }

    public static long intervalToMonths(SqlIntervalLiteral.IntervalValue interval) {
        return SqlParserUtil.intervalToMonths(interval.getIntervalLiteral(), interval.getIntervalQualifier());
    }

    public static long intervalToMonths(String literal, SqlIntervalQualifier intervalQualifier) {
        int[] ret;
        Util.permAssert(intervalQualifier.isYearMonth(), "interval must be year month");
        try {
            ret = intervalQualifier.evaluateIntervalLiteral(literal, intervalQualifier.getParserPosition());
            assert (ret != null);
        }
        catch (EigenbaseContextException e) {
            throw Util.newInternal(e, "error parsing year-to-month interval " + literal);
        }
        long l = 0L;
        long[] conv = new long[2];
        conv[1] = 1L;
        conv[0] = conv[1] * 12L;
        for (int i = 1; i < ret.length; ++i) {
            l += conv[i - 1] * (long)ret[i];
        }
        return (long)ret[0] * l;
    }

    public static String strip(String s, String startQuote, String endQuote, String escape, Casing casing) {
        if (startQuote != null) {
            assert (endQuote != null);
            assert (startQuote.length() == 1);
            assert (endQuote.length() == 1);
            assert (escape != null);
            assert (s.startsWith(startQuote) && s.endsWith(endQuote)) : s;
            s = s.substring(1, s.length() - 1).replace(escape, endQuote);
        }
        switch (casing) {
            case TO_UPPER: {
                return s.toUpperCase();
            }
            case TO_LOWER: {
                return s.toLowerCase();
            }
        }
        return s;
    }

    public static String trim(String s, String chars) {
        char c;
        int stop;
        char c2;
        int start;
        if (s.length() == 0) {
            return "";
        }
        for (start = 0; start < s.length() && chars.indexOf(c2 = s.charAt(start)) >= 0; ++start) {
        }
        for (stop = s.length(); stop > start && chars.indexOf(c = s.charAt(stop - 1)) >= 0; --stop) {
        }
        if (start >= stop) {
            return "";
        }
        return s.substring(start, stop);
    }

    public static String getTokenVal(String token) {
        int endIndex;
        if (!token.startsWith("\"")) {
            return null;
        }
        int startIndex = token.indexOf("\"");
        String tokenVal = token.substring(startIndex + 1, endIndex = token.lastIndexOf("\""));
        char c = tokenVal.charAt(0);
        if (Character.isLetter(c)) {
            return tokenVal;
        }
        return null;
    }

    public static ParsedCollation parseCollation(String in) {
        Locale locale;
        StringTokenizer st = new StringTokenizer(in, "$");
        String charsetStr = st.nextToken();
        String localeStr = st.nextToken();
        String strength = st.countTokens() > 0 ? st.nextToken() : SaffronProperties.instance().defaultCollationStrength.get();
        Charset charset = Charset.forName(charsetStr);
        String[] localeParts = localeStr.split("_");
        if (1 == localeParts.length) {
            locale = new Locale(localeParts[0]);
        } else if (2 == localeParts.length) {
            locale = new Locale(localeParts[0], localeParts[1]);
        } else if (3 == localeParts.length) {
            locale = new Locale(localeParts[0], localeParts[1], localeParts[2]);
        } else {
            throw Static.RESOURCE.illegalLocaleFormat(localeStr).ex();
        }
        return new ParsedCollation(charset, locale, strength);
    }

    public static SqlNode[] toNodeArray(List<SqlNode> list) {
        return list.toArray(new SqlNode[list.size()]);
    }

    public static SqlNode[] toNodeArray(SqlNodeList list) {
        return list.toArray();
    }

    public static <T> void replaceSublist(List<T> list, int start, int end, T o) {
        Util.pre(list != null, "list != null");
        Util.pre(start < end, "start < end");
        for (int i = end - 1; i > start; --i) {
            list.remove(i);
        }
        list.set(start, o);
    }

    public static SqlNode toTree(List<Object> list) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Attempting to reduce " + list);
        }
        SqlNode node = SqlParserUtil.toTreeEx(list, 0, 0, SqlKind.OTHER);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reduced " + node);
        }
        return node;
    }

    public static SqlNode toTreeEx(List<Object> list, int start, int minPrec, SqlKind stopperKind) {
        int count;
        block0: while ((count = list.size()) > start + 1) {
            int i = start + 1;
            while (i < count) {
                SqlNode leftExp;
                int nextLeft;
                SqlOperator next;
                int previousRight;
                SqlOperator previous;
                SqlOperator current = ((ToTreeListItem)list.get(i)).op;
                SqlParserPos currentPos = ((ToTreeListItem)list.get(i)).pos;
                if (stopperKind != SqlKind.OTHER && current.getKind() == stopperKind) break block0;
                int left = current.getLeftPrec();
                int right = current.getRightPrec();
                if (left < minPrec) break block0;
                if (current instanceof SqlBinaryOperator) {
                    if (i == start + 1) {
                        previous = null;
                        previousRight = 0;
                    } else {
                        previous = ((ToTreeListItem)list.get(i - 2)).op;
                        previousRight = previous.getRightPrec();
                    }
                    if (i == count - 2) {
                        next = null;
                        nextLeft = 0;
                    } else {
                        next = ((ToTreeListItem)list.get(i + 2)).op;
                        nextLeft = next.getLeftPrec();
                        if (next.getKind() == stopperKind && stopperKind != SqlKind.OTHER) {
                            nextLeft = 0;
                        }
                    }
                    if (previousRight < left && right >= nextLeft) {
                        leftExp = (SqlNode)list.get(i - 1);
                        SqlNode rightExp = (SqlNode)list.get(i + 1);
                        SqlParserPos callPos = currentPos.plusAll(new SqlNode[]{leftExp, rightExp});
                        SqlCall newExp = current.createCall(callPos, leftExp, rightExp);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Reduced infix: " + newExp);
                        }
                        SqlParserUtil.replaceSublist(list, i - 1, i + 2, newExp);
                        break;
                    }
                    i += 2;
                    continue;
                }
                if (current instanceof SqlPostfixOperator) {
                    if (i == start + 1) {
                        previous = null;
                        previousRight = 0;
                    } else {
                        previous = ((ToTreeListItem)list.get(i - 2)).op;
                        previousRight = previous.getRightPrec();
                    }
                    if (previousRight < left) {
                        leftExp = (SqlNode)list.get(i - 1);
                        SqlParserPos callPos = currentPos.plusAll(new SqlNode[]{leftExp});
                        SqlCall newExp = current.createCall(callPos, leftExp);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Reduced postfix: " + newExp);
                        }
                        list.remove(i);
                        list.set(i - 1, newExp);
                        break;
                    }
                    ++i;
                    continue;
                }
                if (current instanceof SqlSpecialOperator) {
                    int nextOrdinal;
                    SqlSpecialOperator specOp = (SqlSpecialOperator)current;
                    if (i == start + 1) {
                        previous = null;
                        previousRight = 0;
                    } else {
                        previous = ((ToTreeListItem)list.get(i - 2)).op;
                        previousRight = previous.getRightPrec();
                    }
                    if (i == count - 2) {
                        next = null;
                        nextLeft = 0;
                    } else {
                        next = null;
                        nextLeft = 0;
                        for (nextOrdinal = i + 2; nextOrdinal < count; ++nextOrdinal) {
                            Object listItem = list.get(nextOrdinal);
                            if (!(listItem instanceof ToTreeListItem)) continue;
                            next = ((ToTreeListItem)listItem).op;
                            nextLeft = next.getLeftPrec();
                            if (stopperKind == SqlKind.OTHER || next.getKind() != stopperKind) break;
                            break block0;
                        }
                    }
                    if (nextLeft < minPrec) break block0;
                    if (previousRight < left && right >= nextLeft) {
                        i = specOp.reduceExpr(i, list);
                        if (!LOGGER.isLoggable(Level.FINE)) break;
                        LOGGER.fine("Reduced special op: " + list.get(i));
                        break;
                    }
                    i = nextOrdinal;
                    continue;
                }
                throw Util.newInternal("Unexpected operator type: " + current);
            }
            assert (list.size() < count);
        }
        return (SqlNode)list.get(start);
    }

    public static char checkUnicodeEscapeChar(String s) {
        if (s.length() != 1) {
            throw Static.RESOURCE.unicodeEscapeCharLength(s).ex();
        }
        char c = s.charAt(0);
        if (Character.isDigit(c) || Character.isWhitespace(c) || c == '+' || c == '\"' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
            throw Static.RESOURCE.unicodeEscapeCharIllegal(s).ex();
        }
        return c;
    }

    public static class ToTreeListItem {
        private final SqlOperator op;
        private final SqlParserPos pos;

        public ToTreeListItem(SqlOperator op, SqlParserPos pos) {
            this.op = op;
            this.pos = pos;
        }

        public SqlOperator getOperator() {
            return this.op;
        }

        public SqlParserPos getPos() {
            return this.pos;
        }
    }

    public static class ParsedCollation {
        private final Charset charset;
        private final Locale locale;
        private final String strength;

        public ParsedCollation(Charset charset, Locale locale, String strength) {
            this.charset = charset;
            this.locale = locale;
            this.strength = strength;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getStrength() {
            return this.strength;
        }
    }
}

