/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.util.UnmodifiableArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCase
extends SqlCall {
    SqlNode value;
    SqlNodeList whenList;
    SqlNodeList thenList;
    SqlNode elseExpr;

    public SqlCase(SqlParserPos pos, SqlNode value, SqlNodeList whenList, SqlNodeList thenList, SqlNode elseExpr) {
        super(pos);
        this.value = value;
        this.whenList = whenList;
        this.thenList = thenList;
        this.elseExpr = elseExpr;
    }

    public static SqlCase createSwitched(SqlParserPos pos, SqlNode value, SqlNodeList whenList, SqlNodeList thenList, SqlNode elseClause) {
        if (null != value) {
            List<SqlNode> list = whenList.getList();
            for (int i = 0; i < list.size(); ++i) {
                SqlNode e = list.get(i);
                SqlCall call = e instanceof SqlNodeList ? SqlStdOperatorTable.IN.createCall(pos, value, e) : SqlStdOperatorTable.EQUALS.createCall(pos, value, e);
                list.set(i, call);
            }
        }
        if (null == elseClause) {
            elseClause = SqlLiteral.createNull(pos);
        }
        return new SqlCase(pos, null, whenList, thenList, elseClause);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.CASE;
    }

    @Override
    public SqlOperator getOperator() {
        return SqlStdOperatorTable.CASE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return UnmodifiableArrayList.of(new SqlNode[]{this.value, this.whenList, this.thenList, this.elseExpr});
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.value = operand;
                break;
            }
            case 1: {
                this.whenList = (SqlNodeList)operand;
                break;
            }
            case 2: {
                this.thenList = (SqlNodeList)operand;
                break;
            }
            case 3: {
                this.elseExpr = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNodeList getWhenOperands() {
        return this.whenList;
    }

    public SqlNodeList getThenOperands() {
        return this.thenList;
    }

    public SqlNode getElseOperand() {
        return this.elseExpr;
    }
}

