/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Static;

public class SqlRankFunction
extends SqlAggFunction {
    private final RelDataType type = null;

    public SqlRankFunction(String name) {
        super(name, SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER, null, OperandTypes.NILADIC, SqlFunctionCategory.NUMERIC);
    }

    public boolean requiresOrder() {
        return true;
    }

    public boolean allowsFraming() {
        return false;
    }

    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return this.type;
    }

    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        SqlParserPos pos = call.getParserPosition();
        throw SqlUtil.newContextException(pos, Static.RESOURCE.functionUndefined(call.toString()));
    }
}

