/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.eigenbase.sql.SqlAbstractStringLiteral;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.NlsString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCharStringLiteral
extends SqlAbstractStringLiteral {
    private static final Function<SqlLiteral, NlsString> F = new Function<SqlLiteral, NlsString>(){

        @Override
        public NlsString apply(SqlLiteral literal) {
            return ((SqlCharStringLiteral)literal).getNlsString();
        }
    };

    protected SqlCharStringLiteral(NlsString val, SqlParserPos pos) {
        super(val, SqlTypeName.CHAR, pos);
    }

    public NlsString getNlsString() {
        return (NlsString)this.value;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlCharStringLiteral((NlsString)this.value, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        assert (this.value instanceof NlsString);
        writer.literal(this.value.toString());
    }

    @Override
    protected SqlAbstractStringLiteral concat1(List<SqlLiteral> literals) {
        return new SqlCharStringLiteral(NlsString.concat(Lists.transform(literals, F)), literals.get(0).getParserPosition());
    }
}

