/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.ArrayList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlCall
extends SqlNode {
    public SqlCall(SqlParserPos pos) {
        super(pos);
    }

    public boolean isExpanded() {
        return false;
    }

    public void setOperand(int i, SqlNode operand) {
        throw new UnsupportedOperationException();
    }

    public abstract SqlOperator getOperator();

    public abstract List<SqlNode> getOperandList();

    public <S extends SqlNode> S operand(int i) {
        return (S)this.getOperandList().get(i);
    }

    public int operandCount() {
        return this.getOperandList().size();
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return this.getOperator().createCall(pos, this.getOperandList());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlOperator operator = this.getOperator();
        if (leftPrec > operator.getLeftPrec() || operator.getRightPrec() <= rightPrec && rightPrec != 0 || writer.isAlwaysUseParentheses() && this.isA(SqlKind.EXPRESSION)) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            operator.unparse(writer, this, 0, 0);
            writer.endList(frame);
        } else {
            operator.unparse(writer, this, leftPrec, rightPrec);
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateCall(this, scope);
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, boolean fail) {
        if (node == this) {
            return true;
        }
        if (!(node instanceof SqlCall)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        SqlCall that = (SqlCall)node;
        if (!this.getOperator().getName().equals(that.getOperator().getName())) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        return SqlCall.equalDeep(this.getOperandList(), that.getOperandList(), fail);
    }

    protected String getCallSignature(SqlValidator validator, SqlValidatorScope scope) {
        ArrayList<String> signatureList = new ArrayList<String>();
        for (SqlNode operand : this.getOperandList()) {
            RelDataType argType = validator.deriveType(scope, operand);
            if (null == argType) continue;
            signatureList.add(argType.toString());
        }
        return SqlUtil.getOperatorSignature(this.getOperator(), signatureList);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        return this.getOperator().getMonotonicity(this, scope);
    }

    public boolean isCountStar() {
        SqlIdentifier id;
        Object parm;
        return this.getOperator().isName("COUNT") && this.operandCount() == 1 && (parm = this.operand(0)) instanceof SqlIdentifier && (id = (SqlIdentifier)parm).isStar() && id.names.size() == 1;
    }

    public SqlLiteral getFunctionQuantifier() {
        return null;
    }
}

