/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.Calendar;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util14.ZonelessDate;
import org.eigenbase.util14.ZonelessTime;
import org.eigenbase.util14.ZonelessTimestamp;

abstract class SqlAbstractDateTimeLiteral
extends SqlLiteral {
    protected final boolean hasTimeZone;
    protected final String formatString;
    protected final int precision;

    protected SqlAbstractDateTimeLiteral(Calendar d, boolean tz, SqlTypeName typeName, int precision, String formatString, SqlParserPos pos) {
        super(d, typeName, pos);
        this.hasTimeZone = tz;
        this.precision = precision;
        this.formatString = formatString;
    }

    public int getPrec() {
        return this.precision;
    }

    public String toValue() {
        return Long.toString(this.getCal().getTimeInMillis());
    }

    public Calendar getCal() {
        return (Calendar)this.value;
    }

    public abstract String toString();

    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        return typeFactory.createSqlType(this.getTypeName(), this.getPrec());
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.literal(this.toString());
    }

    protected ZonelessDate getDate() {
        ZonelessDate zd = new ZonelessDate();
        zd.setZonelessTime(this.getCal().getTimeInMillis());
        return zd;
    }

    protected ZonelessTime getTime() {
        ZonelessTime zt = new ZonelessTime();
        zt.setZonelessTime(this.getCal().getTimeInMillis());
        return zt;
    }

    protected ZonelessTimestamp getTimestamp() {
        ZonelessTimestamp zt = new ZonelessTimestamp();
        zt.setZonelessTime(this.getCal().getTimeInMillis());
        return zt;
    }
}

