/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import java.util.List;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexFieldCollation;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexRangeRef;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.rex.RexWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexVisitorImpl<R>
implements RexVisitor<R> {
    protected final boolean deep;

    protected RexVisitorImpl(boolean deep) {
        this.deep = deep;
    }

    @Override
    public R visitInputRef(RexInputRef inputRef) {
        return null;
    }

    @Override
    public R visitLocalRef(RexLocalRef localRef) {
        return null;
    }

    @Override
    public R visitLiteral(RexLiteral literal) {
        return null;
    }

    @Override
    public R visitOver(RexOver over) {
        R r = this.visitCall(over);
        if (!this.deep) {
            return null;
        }
        RexWindow window = over.getWindow();
        for (RexFieldCollation orderKey : window.orderKeys) {
            ((RexNode)orderKey.left).accept(this);
        }
        for (RexNode partitionKey : window.partitionKeys) {
            partitionKey.accept(this);
        }
        window.getLowerBound().accept(this);
        window.getUpperBound().accept(this);
        return r;
    }

    @Override
    public R visitCorrelVariable(RexCorrelVariable correlVariable) {
        return null;
    }

    @Override
    public R visitCall(RexCall call) {
        if (!this.deep) {
            return null;
        }
        R r = null;
        for (RexNode operand : call.operands) {
            r = operand.accept(this);
        }
        return r;
    }

    @Override
    public R visitDynamicParam(RexDynamicParam dynamicParam) {
        return null;
    }

    @Override
    public R visitRangeRef(RexRangeRef rangeRef) {
        return null;
    }

    @Override
    public R visitFieldAccess(RexFieldAccess fieldAccess) {
        if (!this.deep) {
            return null;
        }
        RexNode expr = fieldAccess.getReferenceExpr();
        return expr.accept(this);
    }

    public static boolean visitArrayAnd(RexVisitor<Boolean> visitor, List<RexNode> exprs) {
        for (RexNode expr : exprs) {
            boolean b = expr.accept(visitor);
            if (b) continue;
            return false;
        }
        return true;
    }
}

