/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.linq4j.function.Predicate1;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexVariable;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.ControlFlowException;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexUtil {
    private static final Predicate1<RexNode> NOT_ALWAYS_TRUE_PREDICATE = new Predicate1<RexNode>(){

        @Override
        public boolean apply(RexNode e) {
            return !e.isAlwaysTrue();
        }
    };
    private static final Predicate1<RexNode> NOT_ALWAYS_FALSE_PREDICATE = new Predicate1<RexNode>(){

        @Override
        public boolean apply(RexNode e) {
            return !e.isAlwaysFalse();
        }
    };
    private static final Predicate1<RexNode> IS_FLAT_PREDICATE = new Predicate1<RexNode>(){

        @Override
        public boolean apply(RexNode v1) {
            return RexUtil.isFlat(v1);
        }
    };

    private RexUtil() {
    }

    public static List<RexNode> generateCastExpressions(RexBuilder rexBuilder, RelDataType lhsRowType, RelDataType rhsRowType) {
        List<RelDataTypeField> fieldList = rhsRowType.getFieldList();
        int n = fieldList.size();
        assert (n == lhsRowType.getFieldCount()) : "field count: lhs [" + lhsRowType + "] rhs [" + rhsRowType + "]";
        ArrayList<RexNode> rhsExps = new ArrayList<RexNode>();
        for (RelDataTypeField field : fieldList) {
            rhsExps.add(rexBuilder.makeInputRef(field.getType(), field.getIndex()));
        }
        return RexUtil.generateCastExpressions(rexBuilder, lhsRowType, rhsExps);
    }

    public static List<RexNode> generateCastExpressions(RexBuilder rexBuilder, RelDataType lhsRowType, List<RexNode> rhsExps) {
        List<RelDataTypeField> lhsFields = lhsRowType.getFieldList();
        ArrayList<RexNode> castExps = new ArrayList<RexNode>();
        for (Pair<RelDataTypeField, RexNode> pair : Pair.zip(lhsFields, rhsExps, true)) {
            RexNode rhsExp;
            RelDataType rhsType;
            RelDataTypeField lhsField = (RelDataTypeField)pair.left;
            RelDataType lhsType = lhsField.getType();
            if (lhsType.equals(rhsType = (rhsExp = (RexNode)pair.right).getType())) {
                castExps.add(rhsExp);
                continue;
            }
            castExps.add(rexBuilder.makeCast(lhsType, rhsExp));
        }
        return castExps;
    }

    public static boolean isNullLiteral(RexNode node, boolean allowCast) {
        if (node instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)node;
            if (literal.getTypeName() == SqlTypeName.NULL) {
                assert (null == literal.getValue());
                return true;
            }
            return false;
        }
        if (allowCast && node.isA(SqlKind.CAST)) {
            RexCall call = (RexCall)node;
            if (RexUtil.isNullLiteral((RexNode)call.operands.get(0), false)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(RexNode expr) {
        switch (expr.getKind()) {
            case LITERAL: {
                return ((RexLiteral)expr).getValue2() == null;
            }
            case CAST: {
                return RexUtil.isNull((RexNode)((RexCall)expr).operands.get(0));
            }
        }
        return false;
    }

    public static RexCall findOperatorCall(final SqlOperator operator, RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if (call.getOperator().equals(operator)) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visitCall(call);
                }
            };
            node.accept(visitor);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (RexCall)e.getNode();
        }
    }

    public static boolean containsInputRef(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitInputRef(RexInputRef inputRef) {
                    throw new Util.FoundOne(inputRef);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsFieldAccess(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                    throw new Util.FoundOne(fieldAccess);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containForwardRefs(List<RexNode> exprs, RelDataType inputRowType, boolean fail) {
        ForwardRefFinder visitor = new ForwardRefFinder(inputRowType);
        for (int i = 0; i < exprs.size(); ++i) {
            RexNode expr = exprs.get(i);
            visitor.setLimit(i);
            try {
                expr.accept(visitor);
                continue;
            }
            catch (ForwardRefFinder.IllegalForwardRefException e) {
                Util.swallow(e, null);
                assert (!fail) : "illegal forward reference in " + expr;
                return true;
            }
        }
        return false;
    }

    static boolean containNonTrivialAggs(List<RexNode> exprs, boolean fail) {
        for (RexNode expr : exprs) {
            RexCall rexCall;
            if (!(expr instanceof RexCall) || !((rexCall = (RexCall)expr).getOperator() instanceof SqlAggFunction)) continue;
            for (RexNode operand : rexCall.operands) {
                if (operand instanceof RexLocalRef || operand instanceof RexLiteral) continue;
                assert (!fail) : "contains non trivial agg: " + operand;
                return true;
            }
        }
        return false;
    }

    public static boolean containComplexExprs(List<RexNode> exprs) {
        for (RexNode expr : exprs) {
            if (!(expr instanceof RexCall)) continue;
            for (RexNode operand : ((RexCall)expr).operands) {
                if (RexUtil.isAtomic(operand)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAtomic(RexNode expr) {
        return expr instanceof RexLiteral || expr instanceof RexVariable;
    }

    public static boolean isCallTo(RexNode expr, SqlOperator op) {
        return expr instanceof RexCall && ((RexCall)expr).getOperator() == op;
    }

    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<? extends RexNode> exprs, List<String> names) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (int i = 0; i < exprs.size(); ++i) {
            String name;
            if (names == null || (name = names.get(i)) == null) {
                name = "$f" + i;
            }
            builder.add(name, exprs.get(i).getType());
        }
        return builder.build();
    }

    public static boolean compatibleTypes(List<RexNode> exprs, RelDataType type, boolean fail) {
        List<RelDataTypeField> fields = type.getFieldList();
        if (exprs.size() != fields.size()) {
            assert (!fail) : "rowtype mismatches expressions";
            return false;
        }
        for (int i = 0; i < fields.size(); ++i) {
            RelDataType fieldType;
            RelDataType exprType = exprs.get(i).getType();
            if (RelOptUtil.eq("type1", exprType, "type2", fieldType = fields.get(i).getType(), fail)) continue;
            return false;
        }
        return true;
    }

    public static Pair<String, String> makeKey(RexNode expr) {
        return Pair.of(expr.toString(), expr.getType().getFullTypeString());
    }

    public static boolean containIdentity(List<RexNode> exprs, RelDataType rowType, boolean fail) {
        List<RelDataTypeField> fields = rowType.getFieldList();
        if (exprs.size() < fields.size()) {
            assert (!fail) : "exprs/rowType length mismatch";
            return false;
        }
        for (int i = 0; i < fields.size(); ++i) {
            if (!(exprs.get(i) instanceof RexInputRef)) {
                assert (!fail) : "expr[" + i + "] is not a RexInputRef";
                return false;
            }
            RexInputRef inputRef = (RexInputRef)exprs.get(i);
            if (inputRef.getIndex() != i) {
                assert (!fail) : "expr[" + i + "] has ordinal " + inputRef.getIndex();
                return false;
            }
            if (RelOptUtil.eq("type1", exprs.get(i).getType(), "type2", fields.get(i).getType(), fail)) continue;
            return false;
        }
        return true;
    }

    public static RexNode composeConjunction(RexBuilder rexBuilder, List<RexNode> nodes, boolean nullOnEmpty) {
        List<RexNode> nodes2 = Functions.filter(nodes, NOT_ALWAYS_TRUE_PREDICATE);
        switch (nodes2.size()) {
            case 0: {
                return nullOnEmpty ? null : rexBuilder.makeLiteral(true);
            }
            case 1: {
                return nodes2.get(0);
            }
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, nodes2);
    }

    public static RexNode composeDisjunction(RexBuilder rexBuilder, List<RexNode> nodes, boolean nullOnEmpty) {
        List<RexNode> nodes2 = Functions.filter(nodes, NOT_ALWAYS_FALSE_PREDICATE);
        switch (nodes2.size()) {
            case 0: {
                return nullOnEmpty ? null : rexBuilder.makeLiteral(false);
            }
            case 1: {
                return nodes2.get(0);
            }
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, nodes2);
    }

    public static RelCollation apply(Mappings.TargetMapping mapping, RelCollation collation) {
        List<RelFieldCollation> fieldCollations = RexUtil.applyFields(mapping, collation.getFieldCollations());
        return fieldCollations.equals(collation.getFieldCollations()) ? collation : RelCollationImpl.of(fieldCollations);
    }

    public static RelFieldCollation apply(Mappings.TargetMapping mapping, RelFieldCollation fieldCollation) {
        int target = mapping.getTargetOpt(fieldCollation.getFieldIndex());
        if (target < 0) {
            return null;
        }
        return fieldCollation.copy(target);
    }

    public static List<RelFieldCollation> applyFields(Mappings.TargetMapping mapping, List<RelFieldCollation> fieldCollations) {
        ArrayList<RelFieldCollation> newFieldCollations = new ArrayList<RelFieldCollation>(fieldCollations.size());
        for (RelFieldCollation fieldCollation : fieldCollations) {
            newFieldCollations.add(RexUtil.apply(mapping, fieldCollation));
        }
        return newFieldCollations;
    }

    public static void apply(RexVisitor<Void> visitor, List<? extends RexNode> exprs, RexNode expr) {
        for (RexNode rexNode : exprs) {
            rexNode.accept(visitor);
        }
        if (expr != null) {
            expr.accept(visitor);
        }
    }

    private static boolean isFlat(List<? extends RexNode> exprs, final SqlOperator op) {
        return !RexUtil.isAssociative(op) || !RexUtil.exists(exprs, new Predicate1<RexNode>(){

            @Override
            public boolean apply(RexNode expr) {
                return RexUtil.isCallTo(expr, op);
            }
        });
    }

    public static boolean isFlat(RexNode expr) {
        if (!(expr instanceof RexCall)) {
            return true;
        }
        RexCall call = (RexCall)expr;
        return RexUtil.isFlat(call.getOperands(), call.getOperator()) && RexUtil.all(call.getOperands(), IS_FLAT_PREDICATE);
    }

    private static boolean isAssociative(SqlOperator op) {
        return op.getKind() == SqlKind.AND || op.getKind() == SqlKind.OR;
    }

    public static <E> boolean exists(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (!predicate.apply(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean all(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (predicate.apply(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> List<E> generate(final int size, final Function1<Integer, E> fn) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        return new AbstractList<E>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public E get(int index) {
                return fn.apply(index);
            }
        };
    }

    public static RexNode shift(RexNode node, final int offset) {
        return node.accept(new RexShuttle(){

            public RexNode visitInputRef(RexInputRef input) {
                return new RexInputRef(input.getIndex() + offset, input.getType());
            }
        });
    }

    public static RexNode shift(RexNode node, final int start, final int offset) {
        return node.accept(new RexShuttle(){

            public RexNode visitInputRef(RexInputRef input) {
                int index = input.getIndex();
                if (index < start) {
                    return input;
                }
                return new RexInputRef(index + offset, input.getType());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldAccessFinder
    extends RexVisitorImpl<Void> {
        private final List<RexFieldAccess> fieldAccessList = new ArrayList<RexFieldAccess>();

        public FieldAccessFinder() {
            super(true);
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            this.fieldAccessList.add(fieldAccess);
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            for (RexNode operand : call.operands) {
                operand.accept(this);
            }
            return null;
        }

        public List<RexFieldAccess> getFieldAccessList() {
            return this.fieldAccessList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardRefFinder
    extends RexVisitorImpl<Void> {
        private int limit = -1;
        private final RelDataType inputRowType;

        public ForwardRefFinder(RelDataType inputRowType) {
            super(true);
            this.inputRowType = inputRowType;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            super.visitInputRef(inputRef);
            if (inputRef.getIndex() >= this.inputRowType.getFieldCount()) {
                throw new IllegalForwardRefException();
            }
            return null;
        }

        @Override
        public Void visitLocalRef(RexLocalRef inputRef) {
            super.visitLocalRef(inputRef);
            if (inputRef.getIndex() >= this.limit) {
                throw new IllegalForwardRefException();
            }
            return null;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        static class IllegalForwardRefException
        extends ControlFlowException {
            IllegalForwardRefException() {
            }
        }
    }
}

