/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexMultisetUtil {
    private static final Set<SqlOperator> MULTISET_OPERATORS = ImmutableSet.of(SqlStdOperatorTable.CARDINALITY, SqlStdOperatorTable.CAST, SqlStdOperatorTable.ELEMENT, SqlStdOperatorTable.ELEMENT_SLICE, SqlStdOperatorTable.MULTISET_EXCEPT_ALL, SqlStdOperatorTable.MULTISET_EXCEPT, new SqlOperator[]{SqlStdOperatorTable.MULTISET_INTERSECT_ALL, SqlStdOperatorTable.MULTISET_INTERSECT, SqlStdOperatorTable.MULTISET_UNION_ALL, SqlStdOperatorTable.MULTISET_UNION, SqlStdOperatorTable.IS_A_SET, SqlStdOperatorTable.MEMBER_OF, SqlStdOperatorTable.SUBMULTISET_OF});

    public static boolean containsMultiset(RexNode node, boolean deep) {
        return null != RexMultisetUtil.findFirstMultiset(node, deep);
    }

    public static boolean containsMultiset(List<RexNode> nodes, boolean deep) {
        for (RexNode node : nodes) {
            if (!RexMultisetUtil.containsMultiset(node, deep)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMultiset(RexProgram program) {
        return RexMultisetUtil.containsMultiset(program.getExprList(), true);
    }

    public static boolean isMultisetCast(RexCall call) {
        if (!call.getOperator().equals(SqlStdOperatorTable.CAST)) {
            return false;
        }
        return call.getType().getSqlTypeName() == SqlTypeName.MULTISET;
    }

    public static RexCall findFirstMultiset(RexNode node, boolean deep) {
        if (node instanceof RexFieldAccess) {
            return RexMultisetUtil.findFirstMultiset(((RexFieldAccess)node).getReferenceExpr(), deep);
        }
        if (!(node instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)node;
        RexCall firstOne = null;
        for (SqlOperator op : MULTISET_OPERATORS) {
            firstOne = RexUtil.findOperatorCall(op, call);
            if (null == firstOne) continue;
            if (!firstOne.getOperator().equals(SqlStdOperatorTable.CAST) || RexMultisetUtil.isMultisetCast(firstOne)) break;
            firstOne = null;
        }
        if (!deep && firstOne != call) {
            return null;
        }
        return firstOne;
    }
}

